/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.tm;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.test.cache.infinispan.tm.XaTransactionManagerImpl;

public class JtaPlatformImpl
implements JtaPlatform {
    public TransactionManager retrieveTransactionManager() {
        return XaTransactionManagerImpl.getInstance();
    }

    public UserTransaction retrieveUserTransaction() {
        throw new TransactionException("UserTransaction not used in these tests");
    }

    public Object getTransactionIdentifier(Transaction transaction) {
        return transaction;
    }

    public boolean canRegisterSynchronization() {
        return JtaStatusHelper.isActive((TransactionManager)XaTransactionManagerImpl.getInstance());
    }

    public void registerSynchronization(Synchronization synchronization) {
        try {
            XaTransactionManagerImpl.getInstance().getTransaction().registerSynchronization(synchronization);
        }
        catch (Exception e) {
            throw new TransactionException("Could not obtain transaction from TM");
        }
    }

    public int getCurrentStatus() throws SystemException {
        return JtaStatusHelper.getStatus((TransactionManager)XaTransactionManagerImpl.getInstance());
    }
}

