/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.tm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.test.cache.infinispan.tm.XaTransactionImpl;
import org.hibernate.test.cache.infinispan.tm.XaTransactionManagerImpl;
import org.hibernate.testing.env.ConnectionProviderBuilder;

public class XaConnectionProvider
implements ConnectionProvider {
    private static ConnectionProvider actualConnectionProvider = ConnectionProviderBuilder.buildConnectionProvider();
    private boolean isTransactional;

    public static ConnectionProvider getActualConnectionProvider() {
        return actualConnectionProvider;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return XaConnectionProvider.class.isAssignableFrom(unwrapType) || ConnectionProvider.class.equals((Object)unwrapType) || actualConnectionProvider.getClass().isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (XaConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (ConnectionProvider.class.isAssignableFrom(unwrapType) || actualConnectionProvider.getClass().isAssignableFrom(unwrapType)) {
            return (T)XaConnectionProvider.getActualConnectionProvider();
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void configure(Properties props) throws HibernateException {
    }

    public Connection getConnection() throws SQLException {
        XaTransactionImpl currentTransaction = XaTransactionManagerImpl.getInstance().getCurrentTransaction();
        if (currentTransaction == null) {
            this.isTransactional = false;
            return actualConnectionProvider.getConnection();
        }
        this.isTransactional = true;
        Connection connection = currentTransaction.getEnlistedConnection();
        if (connection == null) {
            connection = actualConnectionProvider.getConnection();
            currentTransaction.enlistConnection(connection);
        }
        return connection;
    }

    public void closeConnection(Connection conn) throws SQLException {
        if (!this.isTransactional) {
            conn.close();
        }
    }

    public void close() throws HibernateException {
        if (actualConnectionProvider instanceof Stoppable) {
            ((Stoppable)actualConnectionProvider).stop();
        }
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }
}

