/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.util;

import java.util.Properties;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.test.cache.infinispan.functional.SingleNodeTestCase;
import org.hibernate.test.cache.infinispan.util.BatchModeJtaPlatform;
import org.hibernate.test.cache.infinispan.util.CacheTestSupport;

public class CacheTestUtil {
    public static Configuration buildConfiguration(String regionPrefix, Class regionFactory, boolean use2ndLevel, boolean useQueries) {
        Configuration cfg = new Configuration();
        cfg.setProperty("hibernate.generate_statistics", "true");
        cfg.setProperty("hibernate.cache.use_structured_entries", "true");
        cfg.setProperty("hibernate.transaction.jta.platform", BatchModeJtaPlatform.class.getName());
        cfg.setProperty("hibernate.cache.region.factory_class", regionFactory.getName());
        cfg.setProperty("hibernate.cache.region_prefix", regionPrefix);
        cfg.setProperty("hibernate.cache.use_second_level_cache", String.valueOf(use2ndLevel));
        cfg.setProperty("hibernate.cache.use_query_cache", String.valueOf(useQueries));
        return cfg;
    }

    public static Configuration buildCustomQueryCacheConfiguration(String regionPrefix, String queryCacheName) {
        Configuration cfg = CacheTestUtil.buildConfiguration(regionPrefix, InfinispanRegionFactory.class, true, true);
        cfg.setProperty("hibernate.cache.infinispan.query.cfg", queryCacheName);
        return cfg;
    }

    public static InfinispanRegionFactory startRegionFactory(ServiceRegistry reg, Configuration cfg) {
        try {
            Settings settings = cfg.buildSettings(reg);
            Properties properties = cfg.getProperties();
            String factoryType = cfg.getProperty("hibernate.cache.region.factory_class");
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryType);
            SingleNodeTestCase.TestInfinispanRegionFactory regionFactory = clazz == InfinispanRegionFactory.class ? new SingleNodeTestCase.TestInfinispanRegionFactory() : (InfinispanRegionFactory)clazz.newInstance();
            regionFactory.start(settings, properties);
            return regionFactory;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InfinispanRegionFactory startRegionFactory(ServiceRegistry reg, Configuration cfg, CacheTestSupport testSupport) {
        InfinispanRegionFactory factory = CacheTestUtil.startRegionFactory(reg, cfg);
        testSupport.registerFactory((RegionFactory)factory);
        return factory;
    }

    public static void stopRegionFactory(InfinispanRegionFactory factory, CacheTestSupport testSupport) {
        factory.stop();
        testSupport.unregisterFactory((RegionFactory)factory);
    }

    private CacheTestUtil() {
    }
}

