/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.hibernate.cache.infinispan.util.CacheCommandInitializer;
import org.hibernate.cache.infinispan.util.EvictAllCommand;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.remoting.rpc.RpcManager;

public class Caches {
    private Caches() {
    }

    public static <T> T withinTx(AdvancedCache cache, Callable<T> c) throws Exception {
        return Caches.withinTx(cache.getTransactionManager(), c);
    }

    public static <T> T withinTx(TransactionManager tm, Callable<T> c) throws Exception {
        if (tm == null) {
            return c.call();
        }
        tm.begin();
        try {
            T e = c.call();
            return e;
        }
        catch (Exception e) {
            tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (tm.getStatus() == 0) {
                tm.commit();
            } else {
                tm.rollback();
            }
        }
    }

    public static AdvancedCache localCache(AdvancedCache cache) {
        return cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
    }

    public static AdvancedCache ignoreReturnValuesCache(AdvancedCache cache) {
        return cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP});
    }

    public static AdvancedCache ignoreReturnValuesCache(AdvancedCache cache, Flag extraFlag) {
        return cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP, extraFlag});
    }

    public static AdvancedCache asyncWriteCache(AdvancedCache cache, Flag extraFlag) {
        return cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP, Flag.FORCE_ASYNCHRONOUS, extraFlag});
    }

    public static AdvancedCache failSilentWriteCache(AdvancedCache cache) {
        return cache.withFlags(new Flag[]{Flag.FAIL_SILENTLY, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP});
    }

    public static AdvancedCache failSilentWriteCache(AdvancedCache cache, Flag extraFlag) {
        return cache.withFlags(new Flag[]{Flag.FAIL_SILENTLY, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP, extraFlag});
    }

    public static AdvancedCache failSilentReadCache(AdvancedCache cache) {
        return cache.withFlags(new Flag[]{Flag.FAIL_SILENTLY, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT});
    }

    public static void broadcastEvictAll(AdvancedCache cache) {
        RpcManager rpcManager = cache.getRpcManager();
        if (rpcManager != null) {
            CacheCommandInitializer factory = (CacheCommandInitializer)cache.getComponentRegistry().getComponent(CacheCommandInitializer.class);
            boolean isSync = Caches.isSynchronousCache(cache);
            EvictAllCommand cmd = factory.buildEvictAllCommand(cache.getName());
            rpcManager.broadcastRpcCommand((ReplicableCommand)cmd, isSync);
        }
    }

    public static boolean isInvalidationCache(AdvancedCache cache) {
        return cache.getCacheConfiguration().clustering().cacheMode().isInvalidation();
    }

    public static boolean isSynchronousCache(AdvancedCache cache) {
        return cache.getCacheConfiguration().clustering().cacheMode().isSynchronous();
    }

    public static boolean isClustered(AdvancedCache cache) {
        return cache.getCacheConfiguration().clustering().cacheMode().isClustered();
    }

    public static void removeAll(AdvancedCache cache) {
        CloseableIterator it = cache.keySet().iterator();
        try {
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        finally {
            it.close();
        }
    }
}

