/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.entity;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.TransactionalAccessDelegate;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;

class TransactionalAccess
implements EntityRegionAccessStrategy {
    private final EntityRegionImpl region;
    private final TransactionalAccessDelegate delegate;

    TransactionalAccess(EntityRegionImpl region) {
        this.region = region;
        this.delegate = new TransactionalAccessDelegate(region, region.getPutFromLoadValidator());
    }

    public void evict(Object key) throws CacheException {
        this.delegate.evict(key);
    }

    public void evictAll() throws CacheException {
        this.delegate.evictAll();
    }

    public Object get(SessionImplementor session, Object key, long txTimestamp) throws CacheException {
        return this.delegate.get(key, txTimestamp);
    }

    public EntityRegion getRegion() {
        return this.region;
    }

    public boolean insert(SessionImplementor session, Object key, Object value, Object version) throws CacheException {
        return this.delegate.insert(key, value, version);
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.delegate.putFromLoad(key, value, txTimestamp, version);
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.delegate.putFromLoad(key, value, txTimestamp, version, minimalPutOverride);
    }

    public void remove(SessionImplementor session, Object key) throws CacheException {
        this.delegate.remove(key);
    }

    public void removeAll() throws CacheException {
        this.delegate.removeAll();
    }

    public boolean update(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return this.delegate.update(key, value, currentVersion, previousVersion);
    }

    public SoftLock lockItem(SessionImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) throws CacheException {
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        return false;
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.region.getCacheKeysFactory().createEntityKey(id, persister, factory, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.region.getCacheKeysFactory().getEntityId(cacheKey);
    }
}

