/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.util.CacheCommandInitializer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.InvalidationInterceptor;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class NonTxInvalidationInterceptor
extends BaseRpcInterceptor
implements JmxStatisticsExposer {
    private final AtomicLong invalidations = new AtomicLong(0L);
    private final PutFromLoadValidator putFromLoadValidator;
    private CommandsFactory commandsFactory;
    private CacheCommandInitializer commandInitializer;
    private boolean statisticsEnabled;
    private static final Log log = LogFactory.getLog(InvalidationInterceptor.class);

    public NonTxInvalidationInterceptor(PutFromLoadValidator putFromLoadValidator) {
        this.putFromLoadValidator = putFromLoadValidator;
    }

    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectDependencies(CommandsFactory commandsFactory, CacheCommandInitializer commandInitializer) {
        this.commandsFactory = commandsFactory;
        this.commandInitializer = commandInitializer;
    }

    @Start
    private void start() {
        this.setStatisticsEnabled(this.cacheConfiguration.jmxStatistics().enabled());
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (!this.isPutForExternalRead((FlagAffectedCommand)command)) {
            return this.handleInvalidate(ctx, (WriteCommand)command, new Object[]{command.getKey()});
        }
        return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleInvalidate(ctx, (WriteCommand)command, new Object[]{command.getKey()});
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleInvalidate(ctx, (WriteCommand)command, new Object[]{command.getKey()});
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (!this.isLocalModeForced((FlagAffectedCommand)command) && ctx.isOriginLocal()) {
            this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(this.defaultSynchronous));
        }
        return retval;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (!this.isPutForExternalRead((FlagAffectedCommand)command)) {
            return this.handleInvalidate(ctx, (WriteCommand)command, command.getMap().keySet().toArray());
        }
        return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
    }

    private Object handleInvalidate(InvocationContext ctx, WriteCommand command, Object[] keys) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (command.isSuccessful() && keys != null && keys.length != 0) {
            this.invalidateAcrossCluster((FlagAffectedCommand)command, keys);
        }
        return retval;
    }

    private void invalidateAcrossCluster(FlagAffectedCommand command, Object[] keys) throws Throwable {
        this.incrementInvalidations();
        Object lockOwner = this.putFromLoadValidator.registerRemoteInvalidations(keys);
        if (!this.isLocalModeForced(command)) {
            Object invalidateCommand = lockOwner == null ? this.commandsFactory.buildInvalidateCommand(InfinispanCollections.emptySet(), keys) : this.commandInitializer.buildBeginInvalidationCommand(InfinispanCollections.emptySet(), keys, lockOwner);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache [" + this.rpcManager.getAddress() + "] replicating " + invalidateCommand));
            }
            this.rpcManager.invokeRemotely(null, (ReplicableCommand)invalidateCommand, this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command)));
        }
    }

    private void incrementInvalidations() {
        if (this.statisticsEnabled) {
            this.invalidations.incrementAndGet();
        }
    }

    private boolean isPutForExternalRead(FlagAffectedCommand command) {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            log.trace((Object)"Put for external read called.  Suppressing clustered invalidation.");
            return true;
        }
        return false;
    }

    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.invalidations.set(0L);
    }

    @ManagedAttribute(displayName="Statistics enabled", description="Enables or disables the gathering of statistics by this component", dataType=DataType.TRAIT, writable=true)
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(@Parameter(name="enabled", description="Whether statistics should be enabled or disabled (true/false)") boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @ManagedAttribute(description="Number of invalidations", displayName="Number of invalidations", measurementType=MeasurementType.TRENDSUP)
    public long getInvalidations() {
        return this.invalidations.get();
    }
}

