/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.timestamp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transaction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.timestamp.TimestampsRegionImpl;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;

@Listener
public class ClusteredTimestampsRegionImpl
extends TimestampsRegionImpl {
    private final Map localCache = new ConcurrentHashMap();

    public ClusteredTimestampsRegionImpl(AdvancedCache cache, String name, RegionFactory factory) {
        super(cache, name, factory);
        cache.addListener((Object)this);
        this.populateLocalCache();
    }

    @Override
    protected AdvancedCache getTimestampsPutCache(AdvancedCache cache) {
        return Caches.asyncWriteCache(cache, Flag.SKIP_LOCKING);
    }

    @Override
    public Object get(SessionImplementor session, Object key) throws CacheException {
        Object value = this.localCache.get(key);
        boolean skipCacheStore = false;
        if (!this.isValid()) {
            skipCacheStore = true;
        }
        if (value == null && this.checkValid() && (value = skipCacheStore ? this.cache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).get(key) : this.cache.get(key)) != null) {
            this.localCache.put(key, value);
        }
        return value;
    }

    @Override
    public void evictAll() throws CacheException {
        Transaction tx = this.suspend();
        try {
            this.invalidateRegion();
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.resume(tx);
        }
    }

    @Override
    public void invalidateRegion() {
        super.invalidateRegion();
        this.localCache.clear();
    }

    @Override
    public void destroy() throws CacheException {
        this.localCache.clear();
        this.cache.removeListener((Object)this);
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateLocalCache() {
        Caches.CollectableCloseableIterable iterable = Caches.keys(this.cache);
        try {
            CloseableIterator closeableIterator = iterable.iterator();
            while (closeableIterator.hasNext()) {
                Object key = closeableIterator.next();
                this.get(null, key);
            }
        }
        finally {
            iterable.close();
        }
    }

    @CacheEntryModified
    public void nodeModified(CacheEntryModifiedEvent event) {
        if (!event.isPre()) {
            this.localCache.put(event.getKey(), event.getValue());
        }
    }

    @CacheEntryRemoved
    public void nodeRemoved(CacheEntryRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        this.localCache.remove(event.getKey());
    }
}

