/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import javax.transaction.TransactionManager;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.TypeEquivalance;
import org.hibernate.cache.infinispan.collection.CollectionRegionImpl;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.cache.infinispan.naturalid.NaturalIdRegionImpl;
import org.hibernate.cache.infinispan.query.QueryResultsRegionImpl;
import org.hibernate.cache.infinispan.timestamp.ClusteredTimestampsRegionImpl;
import org.hibernate.cache.infinispan.timestamp.TimestampsRegionImpl;
import org.hibernate.cache.infinispan.tm.HibernateTransactionManagerLookup;
import org.hibernate.cache.infinispan.util.CacheCommandFactory;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.internal.SimpleCacheKeysFactory;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;

public class InfinispanRegionFactory
implements RegionFactory {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(InfinispanRegionFactory.class);
    private static final String PREFIX = "hibernate.cache.infinispan.";
    private static final String CONFIG_SUFFIX = ".cfg";
    private static final String STRATEGY_SUFFIX = ".eviction.strategy";
    private static final String DEPRECATED_WAKE_UP_INTERVAL_SUFFIX = ".eviction.wake_up_interval";
    private static final String MAX_ENTRIES_SUFFIX = ".eviction.max_entries";
    private static final String WAKE_UP_INTERVAL_SUFFIX = ".expiration.wake_up_interval";
    private static final String LIFESPAN_SUFFIX = ".expiration.lifespan";
    private static final String MAX_IDLE_SUFFIX = ".expiration.max_idle";
    public static final String INFINISPAN_CONFIG_RESOURCE_PROP = "hibernate.cache.infinispan.cfg";
    public static final String INFINISPAN_GLOBAL_STATISTICS_PROP = "hibernate.cache.infinispan.statistics";
    @Deprecated
    public static final String INFINISPAN_USE_SYNCHRONIZATION_PROP = "hibernate.cache.infinispan.use_synchronization";
    private static final Consumer<Configuration> NO_VALIDATION = c -> {};
    public static final String NATURAL_ID_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan." + DataType.NATURAL_ID.key + ".cfg";
    public static final String ENTITY_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan." + DataType.ENTITY.key + ".cfg";
    public static final String IMMUTABLE_ENTITY_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan." + DataType.IMMUTABLE_ENTITY.key + ".cfg";
    public static final String COLLECTION_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan." + DataType.COLLECTION.key + ".cfg";
    public static final String TIMESTAMPS_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan." + DataType.TIMESTAMPS.key + ".cfg";
    public static final String QUERY_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan." + DataType.QUERY.key + ".cfg";
    public static final String PENDING_PUTS_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan." + DataType.PENDING_PUTS.key + ".cfg";
    public static final String DEF_INFINISPAN_CONFIG_RESOURCE = "org/hibernate/cache/infinispan/builder/infinispan-configs.xml";
    public static final String INFINISPAN_CONFIG_LOCAL_RESOURCE = "org/hibernate/cache/infinispan/builder/infinispan-configs-local.xml";
    public static final String DEF_ENTITY_RESOURCE = "entity";
    public static final String DEF_TIMESTAMPS_RESOURCE = "timestamps";
    public static final String DEF_QUERY_RESOURCE = "local-query";
    public static final String DEF_PENDING_PUTS_RESOURCE = "pending-puts";
    @Deprecated
    public static final String PENDING_PUTS_CACHE_NAME = "pending-puts";
    public static final boolean DEF_USE_SYNCHRONIZATION = true;
    protected final Map<String, String> baseConfigurations = new HashMap<String, String>();
    protected final Map<String, ConfigurationBuilder> configOverrides = new HashMap<String, ConfigurationBuilder>();
    private CacheKeysFactory cacheKeysFactory;
    private ConfigurationBuilderHolder defaultConfiguration;
    private final Map<DataType, Configuration> dataTypeConfigurations = new HashMap<DataType, Configuration>();
    private EmbeddedCacheManager manager;
    private TransactionManagerLookup transactionManagerlookup;
    private TransactionManager transactionManager;
    private List<BaseRegion> regions = new ArrayList<BaseRegion>();
    private SessionFactoryOptions settings;
    private Boolean globalStats;

    public InfinispanRegionFactory() {
    }

    public InfinispanRegionFactory(Properties props) {
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Building collection cache region [" + regionName + "]");
        }
        AdvancedCache cache = this.getCache(regionName, DataType.COLLECTION, metadata);
        CollectionRegionImpl region = new CollectionRegionImpl(cache, regionName, this.transactionManager, metadata, this, this.getCacheKeysFactory());
        this.startRegion(region);
        return region;
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) {
        if (log.isDebugEnabled()) {
            log.debugf("Building entity cache region [%s] (mutable=%s, versioned=%s)", regionName, metadata.isMutable(), metadata.isVersioned());
        }
        AdvancedCache cache = this.getCache(regionName, metadata.isMutable() ? DataType.ENTITY : DataType.IMMUTABLE_ENTITY, metadata);
        EntityRegionImpl region = new EntityRegionImpl(cache, regionName, this.transactionManager, metadata, this, this.getCacheKeysFactory());
        this.startRegion(region);
        return region;
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) {
        if (log.isDebugEnabled()) {
            log.debug("Building natural id cache region [" + regionName + "]");
        }
        AdvancedCache cache = this.getCache(regionName, DataType.NATURAL_ID, metadata);
        NaturalIdRegionImpl region = new NaturalIdRegionImpl(cache, regionName, this.transactionManager, metadata, this, this.getCacheKeysFactory());
        this.startRegion(region);
        return region;
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug("Building query results cache region [" + regionName + "]");
        }
        AdvancedCache cache = this.getCache(regionName, DataType.QUERY, null);
        QueryResultsRegionImpl region = new QueryResultsRegionImpl(cache, regionName, this.transactionManager, this);
        this.startRegion(region);
        return region;
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug("Building timestamps cache region [" + regionName + "]");
        }
        AdvancedCache cache = this.getCache(regionName, DataType.TIMESTAMPS, null);
        TimestampsRegionImpl region = this.createTimestampsRegion(cache, regionName);
        this.startRegion(region);
        return region;
    }

    protected TimestampsRegionImpl createTimestampsRegion(AdvancedCache cache, String regionName) {
        if (Caches.isClustered(cache)) {
            return new ClusteredTimestampsRegionImpl(cache, regionName, this);
        }
        return new TimestampsRegionImpl(cache, regionName, this);
    }

    public Configuration getPendingPutsCacheConfiguration() {
        return this.dataTypeConfigurations.get((Object)DataType.PENDING_PUTS);
    }

    private CacheKeysFactory getCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis();
    }

    public void setCacheManager(EmbeddedCacheManager manager) {
        this.manager = manager;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.manager;
    }

    public void start(SessionFactoryOptions settings, Properties properties) throws CacheException {
        log.debug("Starting Infinispan region factory");
        this.cacheKeysFactory = this.determineCacheKeysFactory(settings, properties);
        try {
            this.settings = settings;
            this.transactionManagerlookup = this.createTransactionManagerLookup(settings, properties);
            this.transactionManager = this.transactionManagerlookup.getTransactionManager();
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                int prefixLoc = key.indexOf(PREFIX);
                if (prefixLoc == -1) continue;
                this.parseProperty(prefixLoc, key, this.extractProperty(key, properties));
            }
            this.defaultConfiguration = this.loadConfiguration((ServiceRegistry)settings.getServiceRegistry(), DEF_INFINISPAN_CONFIG_RESOURCE);
            this.manager = this.createCacheManager(properties, (ServiceRegistry)settings.getServiceRegistry());
            if (!this.manager.getCacheManagerConfiguration().isClustered()) {
                this.defaultConfiguration = this.loadConfiguration((ServiceRegistry)settings.getServiceRegistry(), INFINISPAN_CONFIG_LOCAL_RESOURCE);
            }
            this.defineDataTypeCacheConfigurations();
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw log.unableToStart(t);
        }
    }

    private CacheKeysFactory determineCacheKeysFactory(SessionFactoryOptions settings, Properties properties) {
        CacheKeysFactory implicitFactory = settings.getMultiTenancyStrategy() != MultiTenancyStrategy.NONE ? DefaultCacheKeysFactory.INSTANCE : SimpleCacheKeysFactory.INSTANCE;
        return (CacheKeysFactory)((StrategySelector)settings.getServiceRegistry().getService(StrategySelector.class)).resolveDefaultableStrategy(CacheKeysFactory.class, properties.get("hibernate.cache.keys_factory"), (Object)implicitFactory);
    }

    protected EmbeddedCacheManager createCacheManager(Properties properties, ServiceRegistry serviceRegistry) {
        String configFile;
        if (properties.containsKey(INFINISPAN_USE_SYNCHRONIZATION_PROP)) {
            log.propertyUseSynchronizationDeprecated();
        }
        ConfigurationBuilderHolder cfgHolder = (configFile = ConfigurationHelper.extractPropertyValue((String)INFINISPAN_CONFIG_RESOURCE_PROP, (Properties)properties)) != null ? this.loadConfiguration(serviceRegistry, configFile) : this.defaultConfiguration;
        String globalStatsStr = this.extractProperty(INFINISPAN_GLOBAL_STATISTICS_PROP, properties);
        if (globalStatsStr != null) {
            this.globalStats = Boolean.parseBoolean(globalStatsStr);
        }
        if (this.globalStats != null) {
            cfgHolder.getGlobalConfigurationBuilder().globalJmxStatistics().enabled(this.globalStats.booleanValue());
        }
        return this.createCacheManager(cfgHolder);
    }

    protected EmbeddedCacheManager createCacheManager(ConfigurationBuilderHolder cfgHolder) {
        return new DefaultCacheManager(cfgHolder, true);
    }

    protected TransactionManagerLookup createTransactionManagerLookup(SessionFactoryOptions settings, Properties properties) {
        return new HibernateTransactionManagerLookup(settings, properties);
    }

    public void stop() {
        log.debug("Stop region factory");
        this.stopCacheRegions();
        this.stopCacheManager();
    }

    protected void stopCacheRegions() {
        log.debug("Clear region references");
        this.getCacheCommandFactory().clearRegions(this.regions);
        this.regions.forEach(region -> {
            region.getCache().stop();
            this.manager.undefineConfiguration(region.getCache().getName());
        });
        this.regions.clear();
    }

    protected void stopCacheManager() {
        log.debug("Stop cache manager");
        this.manager.stop();
    }

    private ConfigurationBuilderHolder loadConfiguration(ServiceRegistry serviceRegistry, final String configFile) {
        final FileLookup fileLookup = FileLookupFactory.newInstance();
        final ClassLoader infinispanClassLoader = InfinispanRegionFactory.class.getClassLoader();
        return (ConfigurationBuilderHolder)((ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class)).workWithClassLoader((ClassLoaderService.Work)new ClassLoaderService.Work<ConfigurationBuilderHolder>(){

            public ConfigurationBuilderHolder doWork(ClassLoader classLoader) {
                ConfigurationBuilderHolder configurationBuilderHolder;
                InputStream is = null;
                try {
                    ConfigurationBuilderHolder holder;
                    is = fileLookup.lookupFile(configFile, classLoader);
                    if (is == null) {
                        classLoader = infinispanClassLoader;
                        is = FileLookupFactory.newInstance().lookupFileStrict(configFile, classLoader);
                    }
                    ParserRegistry parserRegistry = new ParserRegistry(infinispanClassLoader);
                    configurationBuilderHolder = holder = InfinispanRegionFactory.parseWithOverridenClassLoader(parserRegistry, is, infinispanClassLoader);
                }
                catch (IOException e) {
                    try {
                        throw log.unableToCreateCacheManager(e);
                    }
                    catch (Throwable throwable) {
                        Util.close(is);
                        throw throwable;
                    }
                }
                Util.close((Closeable)is);
                return configurationBuilderHolder;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigurationBuilderHolder parseWithOverridenClassLoader(ParserRegistry configurationParser, InputStream is, ClassLoader infinispanClassLoader) {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(infinispanClassLoader);
            ConfigurationBuilderHolder builderHolder = configurationParser.parse(is);
            builderHolder.getGlobalConfigurationBuilder().classLoader(infinispanClassLoader);
            ConfigurationBuilderHolder configurationBuilderHolder = builderHolder;
            return configurationBuilderHolder;
        }
        finally {
            currentThread.setContextClassLoader(originalContextClassLoader);
        }
    }

    private void startRegion(BaseRegion region) {
        this.regions.add(region);
        this.getCacheCommandFactory().addRegion(region);
    }

    private void parseProperty(int prefixLoc, String key, String value) {
        int suffixLoc = key.indexOf(CONFIG_SUFFIX);
        if (suffixLoc != -1 && !key.equals(INFINISPAN_CONFIG_RESOURCE_PROP)) {
            String regionName = key.substring(prefixLoc + PREFIX.length(), suffixLoc);
            this.baseConfigurations.put(regionName, value);
        } else {
            suffixLoc = key.indexOf(STRATEGY_SUFFIX);
            if (suffixLoc != -1) {
                ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                builder.eviction().strategy(EvictionStrategy.valueOf((String)value));
            } else {
                suffixLoc = key.indexOf(WAKE_UP_INTERVAL_SUFFIX);
                if (suffixLoc != -1 || (suffixLoc = key.indexOf(DEPRECATED_WAKE_UP_INTERVAL_SUFFIX)) != -1) {
                    ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                    builder.expiration().wakeUpInterval(Long.parseLong(value));
                } else {
                    suffixLoc = key.indexOf(MAX_ENTRIES_SUFFIX);
                    if (suffixLoc != -1) {
                        ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                        builder.eviction().maxEntries(Long.parseLong(value));
                    } else {
                        suffixLoc = key.indexOf(LIFESPAN_SUFFIX);
                        if (suffixLoc != -1) {
                            ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                            builder.expiration().lifespan(Long.parseLong(value));
                        } else {
                            suffixLoc = key.indexOf(MAX_IDLE_SUFFIX);
                            if (suffixLoc != -1) {
                                ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                                builder.expiration().maxIdle(Long.parseLong(value));
                            }
                        }
                    }
                }
            }
        }
    }

    private String extractProperty(String key, Properties properties) {
        String value = ConfigurationHelper.extractPropertyValue((String)key, (Properties)properties);
        log.debugf("Configuration override via property %s: %s", key, value);
        return value;
    }

    private ConfigurationBuilder getOrCreateConfig(int prefixLoc, String key, int suffixLoc) {
        String name = key.substring(prefixLoc + PREFIX.length(), suffixLoc);
        ConfigurationBuilder builder = this.configOverrides.get(name);
        if (builder == null) {
            builder = new ConfigurationBuilder();
            this.configOverrides.put(name, builder);
        }
        return builder;
    }

    private void defineDataTypeCacheConfigurations() {
        for (DataType type : DataType.values()) {
            ConfigurationBuilder override;
            ConfigurationBuilder builder;
            Configuration configuration;
            String cacheName = this.baseConfigurations.get(type.key);
            if (cacheName == null) {
                cacheName = type.defaultCacheName;
            }
            if ((configuration = this.manager.getCacheConfiguration(cacheName)) == null) {
                log.debugf("Cache configuration not found for %s", (Object)type);
                if (!cacheName.equals(type.defaultCacheName)) {
                    log.customConfigForTypeNotFound(cacheName, type.key);
                }
                if ((builder = (ConfigurationBuilder)this.defaultConfiguration.getNamedConfigurationBuilders().get(type.defaultCacheName)) == null) {
                    throw new IllegalStateException("Generic data types must have default configuration, none found for " + (Object)((Object)type));
                }
            } else {
                builder = new ConfigurationBuilder().read(configuration);
            }
            if ((override = this.configOverrides.get(type.key)) != null) {
                builder.read(override.build(false));
            }
            builder.template(true);
            this.configureTransactionManager(builder);
            this.dataTypeConfigurations.put(type, builder.build());
        }
    }

    protected AdvancedCache getCache(String regionName, DataType type, CacheDataDescription metadata) {
        AdvancedCache cache;
        if (!this.manager.cacheExists(regionName)) {
            ConfigurationBuilder override;
            String templateCacheName = this.baseConfigurations.get(regionName);
            Configuration configuration = null;
            ConfigurationBuilder builder = new ConfigurationBuilder();
            if (templateCacheName != null) {
                configuration = this.manager.getCacheConfiguration(templateCacheName);
                if (configuration == null) {
                    log.customConfigForRegionNotFound(templateCacheName, regionName, type.key);
                } else {
                    log.debugf("Region '%s' will use cache template '%s'", regionName, templateCacheName);
                    builder.read(configuration);
                    this.configureTransactionManager(builder);
                }
            }
            if (configuration == null) {
                configuration = this.dataTypeConfigurations.get((Object)type);
                if (configuration == null) {
                    throw new IllegalStateException("Configuration not defined for type " + type.key);
                }
                builder.read(configuration);
            }
            if ((override = this.configOverrides.get(regionName)) != null) {
                log.debugf("Region '%s' has additional configuration set through properties.", regionName);
                builder.read(override.build(false));
            }
            if (this.settings.getMultiTenancyStrategy() == MultiTenancyStrategy.NONE && metadata != null && metadata.getKeyType() != null) {
                builder.dataContainer().keyEquivalence((Equivalence)new TypeEquivalance(metadata.getKeyType()));
            }
            if (this.globalStats != null) {
                builder.jmxStatistics().enabled(this.globalStats.booleanValue()).available(this.globalStats.booleanValue());
            }
            configuration = builder.build();
            type.validate(configuration);
            this.manager.defineConfiguration(regionName, configuration);
        }
        if (!(cache = this.manager.getCache(regionName).getAdvancedCache()).getStatus().allowInvocations()) {
            cache.start();
        }
        return this.createCacheWrapper(cache);
    }

    private CacheCommandFactory getCacheCommandFactory() {
        GlobalComponentRegistry globalCr = this.manager.getGlobalComponentRegistry();
        Map factories = (Map)globalCr.getComponent("org.infinispan.modules.command.factories");
        for (ModuleCommandFactory factory : factories.values()) {
            if (!(factory instanceof CacheCommandFactory)) continue;
            return (CacheCommandFactory)factory;
        }
        throw log.cannotInstallCommandFactory();
    }

    protected AdvancedCache createCacheWrapper(AdvancedCache cache) {
        return cache;
    }

    private void configureTransactionManager(ConfigurationBuilder builder) {
        TransactionConfiguration transaction = builder.transaction().create();
        if (transaction.transactionMode().isTransactional()) {
            String ispnTmLookupClassName = transaction.transactionManagerLookup().getClass().getName();
            String hbTmLookupClassName = HibernateTransactionManagerLookup.class.getName();
            if (GenericTransactionManagerLookup.class.getName().equals(ispnTmLookupClassName)) {
                log.debug("Using default Infinispan transaction manager lookup instance (GenericTransactionManagerLookup), overriding it with Hibernate transaction manager lookup");
                builder.transaction().transactionManagerLookup(this.transactionManagerlookup);
            } else if (ispnTmLookupClassName != null && !ispnTmLookupClassName.equals(hbTmLookupClassName)) {
                log.debug("Infinispan is configured [" + ispnTmLookupClassName + "] with a different transaction manager lookup " + "class than Hibernate [" + hbTmLookupClassName + "]");
            } else {
                builder.transaction().transactionManagerLookup(this.transactionManagerlookup);
            }
            builder.transaction().useSynchronization(true);
        }
    }

    static /* synthetic */ Consumer access$000() {
        return NO_VALIDATION;
    }

    public static enum DataType {
        ENTITY("entity", "entity", InfinispanRegionFactory.access$000()),
        NATURAL_ID("naturalid", "entity", InfinispanRegionFactory.access$000()),
        COLLECTION("collection", "entity", InfinispanRegionFactory.access$000()),
        IMMUTABLE_ENTITY("immutable-entity", "entity", InfinispanRegionFactory.access$000()),
        TIMESTAMPS("timestamps", "timestamps", c -> {
            if (c.clustering().cacheMode().isInvalidation()) {
                throw log.timestampsMustNotUseInvalidation();
            }
            if (c.eviction().strategy() != EvictionStrategy.NONE) {
                throw log.timestampsMustNotUseEviction();
            }
        }),
        QUERY("query", "local-query", InfinispanRegionFactory.access$000()),
        PENDING_PUTS("pending-puts", "pending-puts", c -> {
            if (!c.isTemplate()) {
                log.pendingPutsShouldBeTemplate();
            }
            if (c.clustering().cacheMode().isClustered()) {
                throw log.pendingPutsMustNotBeClustered();
            }
            if (c.transaction().transactionMode().isTransactional()) {
                throw log.pendingPutsMustNotBeTransactional();
            }
            if (c.expiration().maxIdle() <= 0L) {
                throw log.pendingPutsMustHaveMaxIdle();
            }
        });

        public final String key;
        private final String defaultCacheName;
        private final Consumer<Configuration> validation;

        private DataType(String key, String defaultCacheName, Consumer<Configuration> validation) {
            this.key = key;
            this.defaultCacheName = defaultCacheName;
            this.validation = validation;
        }

        public void validate(Configuration configuration) {
            this.validation.accept(configuration);
        }
    }
}

