/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import org.hibernate.cache.infinispan.access.BaseInvalidationInterceptor;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.util.CacheCommandInitializer;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InvalidationInterceptor;
import org.infinispan.jmx.annotations.MBean;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class NonTxInvalidationInterceptor
extends BaseInvalidationInterceptor {
    private final PutFromLoadValidator putFromLoadValidator;
    private CacheCommandInitializer commandInitializer;
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(InvalidationInterceptor.class);

    public NonTxInvalidationInterceptor(PutFromLoadValidator putFromLoadValidator) {
        this.putFromLoadValidator = putFromLoadValidator;
    }

    @Inject
    public void injectDependencies(CacheCommandInitializer commandInitializer) {
        this.commandInitializer = commandInitializer;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (!this.isPutForExternalRead((FlagAffectedCommand)command)) {
            return this.handleInvalidate(ctx, (WriteCommand)command, new Object[]{command.getKey()});
        }
        return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleInvalidate(ctx, (WriteCommand)command, new Object[]{command.getKey()});
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleInvalidate(ctx, (WriteCommand)command, new Object[]{command.getKey()});
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (!this.isLocalModeForced((FlagAffectedCommand)command) && ctx.isOriginLocal()) {
            this.rpcManager.invokeRemotely(this.getMembers(), (ReplicableCommand)command, this.isSynchronous((FlagAffectedCommand)command) ? this.syncRpcOptions : this.asyncRpcOptions);
        }
        return retval;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (!this.isPutForExternalRead((FlagAffectedCommand)command)) {
            return this.handleInvalidate(ctx, (WriteCommand)command, command.getMap().keySet().toArray());
        }
        return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
    }

    private Object handleInvalidate(InvocationContext ctx, WriteCommand command, Object[] keys) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (command.isSuccessful() && keys != null && keys.length != 0) {
            this.invalidateAcrossCluster((FlagAffectedCommand)command, keys);
        }
        return retval;
    }

    private void invalidateAcrossCluster(FlagAffectedCommand command, Object[] keys) throws Throwable {
        this.incrementInvalidations();
        Object sessionTransactionId = this.putFromLoadValidator.registerRemoteInvalidations(keys);
        if (!this.isLocalModeForced(command)) {
            Object invalidateCommand = sessionTransactionId == null ? this.commandsFactory.buildInvalidateCommand(InfinispanCollections.emptySet(), keys) : this.commandInitializer.buildBeginInvalidationCommand(InfinispanCollections.emptySet(), keys, sessionTransactionId);
            if (log.isDebugEnabled()) {
                log.debug("Cache [" + this.rpcManager.getAddress() + "] replicating " + invalidateCommand);
            }
            this.rpcManager.invokeRemotely(this.getMembers(), (ReplicableCommand)invalidateCommand, this.isSynchronous(command) ? this.syncRpcOptions : this.asyncRpcOptions);
        }
    }

    private boolean isPutForExternalRead(FlagAffectedCommand command) {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            log.trace("Put for external read called.  Suppressing clustered invalidation.");
            return true;
        }
        return false;
    }
}

