/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.impl;

import java.util.Collections;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.access.AccessType;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;

public abstract class BaseRegion
implements Region {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(BaseRegion.class);
    protected final String name;
    protected final AdvancedCache cache;
    protected final AdvancedCache localAndSkipLoadCache;
    protected final TransactionManager tm;
    protected final InfinispanRegionFactory factory;
    protected volatile long lastRegionInvalidation = Long.MIN_VALUE;
    protected int invalidations = 0;

    public BaseRegion(AdvancedCache cache, String name, TransactionManager transactionManager, InfinispanRegionFactory factory) {
        this.cache = cache;
        this.name = name;
        this.tm = transactionManager;
        this.factory = factory;
        this.localAndSkipLoadCache = cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.SKIP_CACHE_LOAD});
    }

    public String getName() {
        return this.name;
    }

    public long getElementCountInMemory() {
        if (this.checkValid()) {
            return this.localAndSkipLoadCache.size();
        }
        return 0L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public int getTimeout() {
        return 60000;
    }

    public long nextTimestamp() {
        return this.factory.nextTimestamp();
    }

    public Map toMap() {
        if (this.checkValid()) {
            return this.cache;
        }
        return Collections.EMPTY_MAP;
    }

    public void destroy() throws CacheException {
        this.cache.stop();
    }

    public boolean contains(Object key) {
        return this.checkValid() && this.cache.containsKey(key);
    }

    public boolean checkValid() {
        return this.lastRegionInvalidation != Long.MAX_VALUE;
    }

    public Transaction suspend() {
        Transaction tx = null;
        try {
            if (this.tm != null) {
                tx = this.tm.suspend();
            }
        }
        catch (SystemException se) {
            throw log.cannotSuspendTx(se);
        }
        return tx;
    }

    public void resume(Transaction tx) {
        try {
            if (tx != null) {
                this.tm.resume(tx);
            }
        }
        catch (Exception e) {
            throw log.cannotResumeTx(e);
        }
    }

    public void invalidateRegion() {
        this.beginInvalidation();
        this.endInvalidation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginInvalidation() {
        if (log.isTraceEnabled()) {
            log.trace("Begin invalidating region: " + this.name);
        }
        BaseRegion baseRegion = this;
        synchronized (baseRegion) {
            this.lastRegionInvalidation = Long.MAX_VALUE;
            ++this.invalidations;
        }
        this.runInvalidation(this.getCurrentTransaction() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endInvalidation() {
        BaseRegion baseRegion = this;
        synchronized (baseRegion) {
            if (--this.invalidations == 0) {
                this.lastRegionInvalidation = this.nextTimestamp();
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("End invalidating region: " + this.name);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public boolean isTransactionAware() {
        return this.tm != null;
    }

    public AdvancedCache getCache() {
        return this.cache;
    }

    protected Transaction getCurrentTransaction() {
        try {
            return this.tm != null ? this.tm.getTransaction() : null;
        }
        catch (SystemException e) {
            throw log.cannotGetCurrentTx(e);
        }
    }

    protected void checkAccessType(AccessType accessType) {
        if (accessType == AccessType.TRANSACTIONAL && !this.cache.getCacheConfiguration().transaction().transactionMode().isTransactional()) {
            log.transactionalStrategyNonTransactionalCache();
        } else if (accessType == AccessType.READ_WRITE && this.cache.getCacheConfiguration().transaction().transactionMode().isTransactional()) {
            log.readWriteStrategyTransactionalCache();
        }
    }

    protected void runInvalidation(boolean inTransaction) {
        if (inTransaction && this.cache.getCacheConfiguration().transaction().transactionMode().isTransactional()) {
            log.tracef("Transaction, clearing one element at the time", new Object[0]);
            Caches.removeAll(this.localAndSkipLoadCache);
        } else {
            log.tracef("Non-transactional, clear in one go", new Object[0]);
            this.localAndSkipLoadCache.clear();
        }
    }

    public InfinispanRegionFactory getRegionFactory() {
        return this.factory;
    }
}

