/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc.access;

import javax.transaction.Transaction;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jbc.TransactionalDataRegionAdapter;
import org.hibernate.cache.jbc.access.PutFromLoadValidator;
import org.hibernate.cache.jbc.access.TransactionalAccessDelegate;
import org.hibernate.cache.jbc.util.CacheHelper;
import org.hibernate.cache.jbc.util.DataVersionAdapter;
import org.hibernate.cache.jbc.util.NonLockingDataVersion;
import org.jboss.cache.config.Option;
import org.jboss.cache.optimistic.DataVersion;

public class OptimisticTransactionalAccessDelegate
extends TransactionalAccessDelegate {
    protected final CacheDataDescription dataDescription;

    public OptimisticTransactionalAccessDelegate(TransactionalDataRegionAdapter region, PutFromLoadValidator validator) {
        super(region, validator);
        this.dataDescription = region.getCacheDataDescription();
    }

    public void evict(Object key) throws CacheException {
        this.putValidator.keyRemoved(key);
        this.region.ensureRegionRootExists();
        Option opt = NonLockingDataVersion.getInvocationOption();
        CacheHelper.remove(this.cache, this.regionFqn, key, opt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() throws CacheException {
        this.putValidator.regionRemoved();
        Transaction tx = this.region.suspend();
        try {
            this.region.ensureRegionRootExists();
            Option opt = NonLockingDataVersion.getInvocationOption();
            CacheHelper.sendEvictAllNotification(this.cache, this.regionFqn, this.region.getMemberId(), opt);
        }
        finally {
            this.region.resume(tx);
        }
    }

    public boolean insert(Object key, Object value, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        this.region.ensureRegionRootExists();
        Option opt = this.getDataVersionOption(version, null);
        if (this.invalidation) {
            opt.setCacheModeLocal(true);
        }
        CacheHelper.put(this.cache, this.regionFqn, key, value, opt);
        return true;
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        if (!this.putValidator.isPutValid(key)) {
            return false;
        }
        this.region.ensureRegionRootExists();
        Option opt = this.getDataVersionOption(version, version);
        return CacheHelper.putForExternalRead(this.cache, this.regionFqn, key, value, opt);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        if (!this.putValidator.isPutValid(key)) {
            return false;
        }
        this.region.ensureRegionRootExists();
        Option opt = this.getDataVersionOption(version, version);
        return CacheHelper.putForExternalRead(this.cache, this.regionFqn, key, value, opt);
    }

    public void remove(Object key) throws CacheException {
        this.putValidator.keyRemoved(key);
        this.region.ensureRegionRootExists();
        Option opt = NonLockingDataVersion.getInvocationOption();
        CacheHelper.remove(this.cache, this.regionFqn, key, opt);
    }

    public void removeAll() throws CacheException {
        this.putValidator.regionRemoved();
        Option opt = NonLockingDataVersion.getInvocationOption();
        CacheHelper.removeAll(this.cache, this.regionFqn, opt);
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.region.ensureRegionRootExists();
        Option opt = this.getDataVersionOption(currentVersion, previousVersion);
        CacheHelper.put(this.cache, this.regionFqn, key, value, opt);
        return true;
    }

    private Option getDataVersionOption(Object currentVersion, Object previousVersion) {
        DataVersion dv = this.dataDescription != null && this.dataDescription.isVersioned() ? new DataVersionAdapter(currentVersion, previousVersion, this.dataDescription.getVersionComparator(), this.dataDescription.toString()) : NonLockingDataVersion.INSTANCE;
        Option opt = new Option();
        opt.setDataVersion(dv);
        return opt;
    }
}

