/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jcache.access;

import java.io.Serializable;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jcache.JCacheMessageLogger;
import org.hibernate.cache.jcache.JCacheRegion;
import org.hibernate.cache.jcache.JCacheTransactionalDataRegion;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.jboss.logging.Logger;

abstract class AbstractReadWriteRegionAccessStrategy<R extends JCacheTransactionalDataRegion> {
    private static final JCacheMessageLogger LOG = (JCacheMessageLogger)Logger.getMessageLogger(JCacheMessageLogger.class, (String)AbstractReadWriteRegionAccessStrategy.class.getName());
    protected final R region;
    protected final Comparator versionComparator;
    private final UUID uuid = UUID.randomUUID();
    private final AtomicLong nextLockId = new AtomicLong();
    private final AtomicLong nextItemId = new AtomicLong();

    public AbstractReadWriteRegionAccessStrategy(R region) {
        this.versionComparator = ((JCacheTransactionalDataRegion)region).getCacheDataDescription().getVersionComparator();
        this.region = region;
    }

    public R getRegion() {
        return this.region;
    }

    public Object get(SharedSessionContractImplementor session, Object key, long txTimestamp) throws CacheException {
        boolean readable;
        Lockable item = (Lockable)((JCacheTransactionalDataRegion)this.region).get(key);
        boolean bl = readable = item != null && item.isReadable(txTimestamp);
        if (readable) {
            return item.getValue();
        }
        return null;
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
        block2: {
            while (true) {
                Lockable item;
                if ((item = (Lockable)((JCacheTransactionalDataRegion)this.region).get(key)) == null) {
                    if (!((JCacheTransactionalDataRegion)this.region).putIfAbsent(key, new Item(value, version, txTimestamp, this.nextItemId()))) continue;
                    return true;
                }
                if (!item.isWriteable(txTimestamp, version, this.versionComparator)) break block2;
                if (((JCacheTransactionalDataRegion)this.region).replace(key, item, new Item(value, version, txTimestamp, this.nextItemId()))) break;
            }
            return true;
        }
        return false;
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.putFromLoad(session, key, value, txTimestamp, version);
    }

    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) throws CacheException {
        Lock lock;
        Lockable item;
        long timeout = ((JCacheRegion)this.region).nextTimestamp() + (long)((JCacheRegion)this.region).getTimeout();
        while (!((item = (Lockable)((JCacheTransactionalDataRegion)this.region).get(key)) == null ? ((JCacheTransactionalDataRegion)this.region).putIfAbsent(key, lock = new Lock(timeout, this.uuid, this.nextLockId(), version)) : ((JCacheTransactionalDataRegion)this.region).replace(key, item, lock = item.lock(timeout, this.uuid, this.nextLockId())))) {
        }
        return lock;
    }

    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) throws CacheException {
        Lockable item;
        while ((item = (Lockable)((JCacheTransactionalDataRegion)this.region).get(key)) != null && item.isUnlockable(lock)) {
            if (!((JCacheTransactionalDataRegion)this.region).replace(key, item, ((Lock)item).unlock(((JCacheRegion)this.region).nextTimestamp()))) continue;
            return;
        }
        this.handleMissingLock(key, item);
    }

    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
    }

    public void removeAll() throws CacheException {
        ((JCacheTransactionalDataRegion)this.region).clear();
    }

    public void evict(Object key) throws CacheException {
        ((JCacheTransactionalDataRegion)this.region).remove(key);
    }

    public void evictAll() throws CacheException {
        ((JCacheTransactionalDataRegion)this.region).clear();
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
        ((JCacheTransactionalDataRegion)this.region).clear();
    }

    private long nextLockId() {
        return this.nextLockId.getAndIncrement();
    }

    protected long nextItemId() {
        return this.nextItemId.getAndIncrement();
    }

    protected void handleMissingLock(Object key, Lockable lock) {
        LOG.missingLock((JCacheRegion)this.region, key, lock);
        long ts = ((JCacheRegion)this.region).nextTimestamp() + (long)((JCacheRegion)this.region).getTimeout();
        Lock newLock = new Lock(ts, this.uuid, this.nextLockId.getAndIncrement(), null).unlock(ts);
        ((JCacheTransactionalDataRegion)this.region).put(key, newLock);
    }

    public static final class Lock
    implements Serializable,
    Lockable,
    SoftLock {
        private static final long serialVersionUID = 2L;
        private final UUID sourceUuid;
        private final long lockId;
        private final Object version;
        private final long timeout;
        private final boolean concurrent;
        private final int multiplicity;
        private final long unlockTimestamp;

        public Lock(long timeout, UUID sourceUuid, long lockId, Object version) {
            this(timeout, sourceUuid, lockId, version, 0L, 1, false);
        }

        private Lock(long timeout, UUID sourceUuid, long lockId, Object version, long unlockTimestamp, int multiplicity, boolean concurrent) {
            this.sourceUuid = sourceUuid;
            this.lockId = lockId;
            this.version = version;
            this.timeout = timeout;
            this.unlockTimestamp = unlockTimestamp;
            this.multiplicity = multiplicity;
            this.concurrent = concurrent;
        }

        @Override
        public boolean isReadable(long txTimestamp) {
            return false;
        }

        @Override
        public boolean isWriteable(long txTimestamp, Object newVersion, Comparator versionComparator) {
            if (txTimestamp > this.timeout) {
                return true;
            }
            if (this.multiplicity > 0) {
                return false;
            }
            return this.version == null ? txTimestamp > this.unlockTimestamp : versionComparator.compare(this.version, newVersion) < 0;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public boolean isUnlockable(SoftLock lock) {
            if (lock == this) {
                return true;
            }
            if (lock instanceof Lock) {
                return this.lockId == ((Lock)lock).lockId && this.sourceUuid.equals(((Lock)lock).sourceUuid);
            }
            return false;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Lock) {
                return this.lockId == ((Lock)o).lockId && this.sourceUuid.equals(((Lock)o).sourceUuid) && this.multiplicity == ((Lock)o).multiplicity;
            }
            return false;
        }

        public int hashCode() {
            int hash = this.sourceUuid != null ? this.sourceUuid.hashCode() : 0;
            return hash ^ Long.hashCode(this.lockId);
        }

        public boolean wasLockedConcurrently() {
            return this.concurrent;
        }

        @Override
        public Lock lock(long timeout, UUID uuid, long lockId) {
            return new Lock(timeout, this.sourceUuid, this.lockId, this.version, 0L, this.multiplicity + 1, true);
        }

        public Lock unlock(long timestamp) {
            if (this.multiplicity == 1) {
                return new Lock(this.timeout, this.sourceUuid, this.lockId, this.version, timestamp, 0, this.concurrent);
            }
            return new Lock(this.timeout, this.sourceUuid, this.lockId, this.version, 0L, this.multiplicity - 1, this.concurrent);
        }

        public String toString() {
            return "Lock Source-UUID:" + this.sourceUuid + " Lock-ID:" + this.lockId;
        }
    }

    protected static final class Item
    implements Serializable,
    Lockable {
        private static final long serialVersionUID = 1L;
        private final Object value;
        private final Object version;
        private final long timestamp;
        private final long itemId;

        Item(Object value, Object version, long timestamp, long itemId) {
            this.value = value;
            this.version = version;
            this.timestamp = timestamp;
            this.itemId = itemId;
        }

        @Override
        public boolean isReadable(long txTimestamp) {
            return txTimestamp > this.timestamp;
        }

        @Override
        public boolean isWriteable(long txTimestamp, Object newVersion, Comparator versionComparator) {
            return this.version != null && versionComparator.compare(this.version, newVersion) < 0;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isUnlockable(SoftLock lock) {
            return false;
        }

        @Override
        public Lock lock(long timeout, UUID uuid, long lockId) {
            return new Lock(timeout, uuid, lockId, this.version);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Item) {
                return this.itemId == ((Item)obj).itemId;
            }
            return false;
        }

        public int hashCode() {
            return Long.hashCode(this.itemId);
        }

        public String toString() {
            return "Item{value=" + this.value + ", version=" + this.version + ", timestamp=" + this.timestamp + '}';
        }
    }

    protected static interface Lockable {
        public boolean isReadable(long var1);

        public boolean isWriteable(long var1, Object var3, Comparator var4);

        public Object getValue();

        public boolean isUnlockable(SoftLock var1);

        public Lock lock(long var1, UUID var3, long var4);
    }
}

