/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.persistence.AccessType;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.ClassWriter;
import org.hibernate.jpamodelgen.MetaEntity;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;

public class Context {
    private static final String DEBUG_PARAMETER = "debug";
    private final Map<String, MetaEntity> metaEntitiesToProcess = new HashMap<String, MetaEntity>();
    private final Map<String, MetaEntity> metaSuperclassAndEmbeddableToProcess = new HashMap<String, MetaEntity>();
    private ProcessingEnvironment pe;
    private boolean logDebug = false;
    private Map<TypeElement, AccessTypeHolder> accessTypes = new HashMap<TypeElement, AccessTypeHolder>();
    private Set<String> elementsAlreadyProcessed = new HashSet<String>();

    public Context(ProcessingEnvironment pe) {
        this.pe = pe;
        String debugParam = pe.getOptions().get(DEBUG_PARAMETER);
        if (debugParam != null && "true".equals(debugParam)) {
            this.logDebug = true;
        }
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.pe;
    }

    public Map<String, MetaEntity> getMetaEntitiesToProcess() {
        return this.metaEntitiesToProcess;
    }

    public Map<String, MetaEntity> getMetaSuperclassAndEmbeddableToProcess() {
        return this.metaSuperclassAndEmbeddableToProcess;
    }

    public void addAccessType(TypeElement element, AccessType accessType) {
        AccessTypeHolder typeHolder = this.accessTypes.get(element);
        if (typeHolder == null) {
            typeHolder = new AccessTypeHolder();
            this.accessTypes.put(element, typeHolder);
        }
        typeHolder.elementAccessType = accessType;
    }

    public void addAccessTypeForHierarchy(TypeElement element, AccessType accessType) {
        AccessTypeHolder typeHolder = this.accessTypes.get(element);
        if (typeHolder == null) {
            typeHolder = new AccessTypeHolder();
            this.accessTypes.put(element, typeHolder);
        }
        typeHolder.hierarchyAccessType = accessType;
    }

    public AccessType getAccessType(TypeElement element) {
        AccessTypeHolder typeHolder = this.accessTypes.get(element);
        return typeHolder != null ? typeHolder.elementAccessType : null;
    }

    public AccessType getDefaultAccessTypeForHerarchy(TypeElement element) {
        AccessTypeHolder typeHolder = this.accessTypes.get(element);
        return typeHolder != null ? typeHolder.hierarchyAccessType : null;
    }

    public Set<String> getElementsAlreadyProcessed() {
        return this.elementsAlreadyProcessed;
    }

    public void processElement(TypeElement element, AccessType defaultAccessTypeForHierarchy) {
        if (this.elementsAlreadyProcessed.contains(element.getQualifiedName().toString())) {
            this.logMessage(Diagnostic.Kind.WARNING, "Element already processed (ignoring): " + element);
            return;
        }
        ClassWriter.writeFile(new AnnotationMetaEntity(element, this, defaultAccessTypeForHierarchy), this);
        this.elementsAlreadyProcessed.add(element.getQualifiedName().toString());
    }

    public void logMessage(Diagnostic.Kind type, String message) {
        if (!this.logDebug && type.equals((Object)Diagnostic.Kind.NOTE)) {
            return;
        }
        this.pe.getMessager().printMessage(type, message);
    }

    private static class AccessTypeHolder {
        public AccessType elementAccessType;
        public AccessType hierarchyAccessType;

        private AccessTypeHolder() {
        }
    }
}

