/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.ClassWriter;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.MetaEntity;
import org.hibernate.jpamodelgen.Version;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.util.TypeUtils;
import org.hibernate.jpamodelgen.xml.XmlParser;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"debug"})
public class JPAMetaModelEntityProcessor
extends AbstractProcessor {
    public static final String DEBUG_OPTION = "debug";
    private static final Boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = Boolean.FALSE;
    private boolean xmlProcessed = false;
    private Context context;

    @Override
    public void init(ProcessingEnvironment env) {
        super.init(env);
        this.context = new Context(env);
        this.context.logMessage(Diagnostic.Kind.NOTE, "Hibernate JPA 2 Static-Metamodel Generator " + Version.getVersionString());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.processingOver()) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Last processing round.");
            this.createMetaModelClasses();
            this.context.logMessage(Diagnostic.Kind.OTHER, "Finished processing");
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        if (!this.xmlProcessed) {
            XmlParser parser = new XmlParser(this.context);
            parser.parsePersistenceXml();
            this.xmlProcessed = true;
        }
        if (!this.hostJPAAnnotations(annotations)) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Current processing round does not contain entities");
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        Set<? extends Element> elements = roundEnvironment.getRootElements();
        for (Element element : elements) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Processing " + element.toString());
            this.handleRootElementAnnotationMirrors(element);
        }
        return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
    }

    private void createMetaModelClasses() {
        for (MetaEntity entity : this.context.getMetaEntitiesToProcess().values()) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Writing meta model for " + entity);
            ClassWriter.writeFile(entity, this.context);
        }
        for (String className : this.context.getElementsAlreadyProcessed()) {
            this.context.getMetaSuperclassAndEmbeddableToProcess().remove(className);
        }
        for (MetaEntity entity : this.context.getMetaSuperclassAndEmbeddableToProcess().values()) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Writing meta model for " + entity);
            ClassWriter.writeFile(entity, this.context);
        }
    }

    private boolean hostJPAAnnotations(Set<? extends TypeElement> annotations) {
        for (TypeElement typeElement : annotations) {
            if (TypeUtils.isTypeElementOfType(typeElement, Entity.class)) {
                return true;
            }
            if (TypeUtils.isTypeElementOfType(typeElement, Embeddable.class)) {
                return true;
            }
            if (!TypeUtils.isTypeElementOfType(typeElement, MappedSuperclass.class)) continue;
            return true;
        }
        return false;
    }

    private void handleRootElementAnnotationMirrors(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            AnnotationMetaEntity metaEntity;
            if (element.getKind() != ElementKind.CLASS) continue;
            if (TypeUtils.isAnnotationMirrorOfType(annotationMirror, Entity.class)) {
                metaEntity = new AnnotationMetaEntity((TypeElement)element, this.context);
                this.context.getMetaEntitiesToProcess().put(metaEntity.getQualifiedName(), metaEntity);
                continue;
            }
            if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, MappedSuperclass.class) && !TypeUtils.isAnnotationMirrorOfType(annotationMirror, Embeddable.class)) continue;
            metaEntity = new AnnotationMetaEntity((TypeElement)element, this.context);
            this.context.getMetaSuperclassAndEmbeddableToProcess().put(metaEntity.getQualifiedName(), metaEntity);
        }
    }
}

