/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import org.hibernate.jpamodelgen.Context;

public class TypeUtils {
    private static final Map<String, String> PRIMITIVES = new HashMap<String, String>();

    public static String toTypeString(TypeMirror type) {
        if (type.getKind().isPrimitive()) {
            return PRIMITIVES.get(((Object)type).toString());
        }
        return ((Object)type).toString();
    }

    public static TypeElement getSuperclassTypeElement(TypeElement element) {
        TypeMirror superClass = element.getSuperclass();
        if (superClass.getKind() == TypeKind.DECLARED) {
            Element superClassElement = ((DeclaredType)superClass).asElement();
            return (TypeElement)superClassElement;
        }
        return null;
    }

    public static String extractClosestRealTypeAsString(TypeMirror type, Context context) {
        if (type instanceof TypeVariable) {
            TypeMirror compositeUpperBound = ((TypeVariable)type).getUpperBound();
            Types types = context.getProcessingEnvironment().getTypeUtils();
            List<? extends TypeMirror> upperBounds = types.directSupertypes(compositeUpperBound);
            if (upperBounds.size() == 0) {
                return ((Object)compositeUpperBound).toString();
            }
            return TypeUtils.extractClosestRealTypeAsString(upperBounds.get(0), context);
        }
        return ((Object)type).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAnnotation(Element element, Class<?> ... annotations) {
        void var5_7;
        assert (element != null);
        assert (annotations != null);
        ArrayList<String> annotationClassNames = new ArrayList<String>();
        Class<?>[] arr$ = annotations;
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_7 < len$) {
            Class<?> clazz = arr$[var5_7];
            annotationClassNames.add(clazz.getName());
            ++var5_7;
        }
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationClassNames.contains(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationMirrorOfType(AnnotationMirror annotationMirror, Class<? extends Annotation> clazz) {
        assert (annotationMirror != null);
        assert (clazz != null);
        String annotationClassName = annotationMirror.getAnnotationType().toString();
        String className = clazz.getName();
        return annotationClassName.equals(className);
    }

    public static boolean isTypeElementOfType(TypeElement element, Class<?> clazz) {
        assert (element != null);
        assert (clazz != null);
        String elementClassName = element.getQualifiedName().toString();
        String className = clazz.getName();
        return elementClassName.equals(className);
    }

    public static AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> clazz) {
        assert (element != null);
        assert (clazz != null);
        AnnotationMirror mirror = null;
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, clazz)) continue;
            mirror = annotationMirror;
            break;
        }
        return mirror;
    }

    public static Object getAnnotationValue(AnnotationMirror annotationMirror, String parameterValue) {
        assert (annotationMirror != null);
        assert (parameterValue != null);
        Object returnValue = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!parameterValue.equals(entry.getKey().getSimpleName().toString())) continue;
            returnValue = entry.getValue().getValue();
            break;
        }
        return returnValue;
    }

    static {
        PRIMITIVES.put("char", "Character");
        PRIMITIVES.put("byte", "Byte");
        PRIMITIVES.put("short", "Short");
        PRIMITIVES.put("int", "Integer");
        PRIMITIVES.put("long", "Long");
        PRIMITIVES.put("boolean", "Boolean");
        PRIMITIVES.put("float", "Float");
        PRIMITIVES.put("double", "Double");
    }
}

