/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.ImportContext;
import org.hibernate.jpamodelgen.ImportContextImpl;
import org.hibernate.jpamodelgen.MetaAttribute;
import org.hibernate.jpamodelgen.MetaEntity;
import org.hibernate.jpamodelgen.util.TypeUtils;
import org.hibernate.jpamodelgen.xml.XmlMetaCollection;
import org.hibernate.jpamodelgen.xml.XmlMetaSingleAttribute;
import org.hibernate.jpamodelgen.xml.jaxb.Attributes;
import org.hibernate.jpamodelgen.xml.jaxb.Basic;
import org.hibernate.jpamodelgen.xml.jaxb.ElementCollection;
import org.hibernate.jpamodelgen.xml.jaxb.Embeddable;
import org.hibernate.jpamodelgen.xml.jaxb.EmbeddableAttributes;
import org.hibernate.jpamodelgen.xml.jaxb.Entity;
import org.hibernate.jpamodelgen.xml.jaxb.Id;
import org.hibernate.jpamodelgen.xml.jaxb.ManyToOne;
import org.hibernate.jpamodelgen.xml.jaxb.MappedSuperclass;
import org.hibernate.jpamodelgen.xml.jaxb.OneToMany;
import org.hibernate.jpamodelgen.xml.jaxb.OneToOne;

public class XmlMetaEntity
implements MetaEntity {
    static Map<String, String> COLLECTIONS = new HashMap<String, String>();
    private final String clazzName;
    private final String packageName;
    private final ImportContext importContext;
    private final List<MetaAttribute> members = new ArrayList<MetaAttribute>();
    private TypeElement element;
    private Context context;

    public XmlMetaEntity(Entity ormEntity, String packageName, TypeElement element, Context context) {
        this.clazzName = ormEntity.getClazz();
        this.packageName = packageName;
        this.context = context;
        this.importContext = new ImportContextImpl(this.getPackageName());
        this.element = element;
        Attributes attributes = ormEntity.getAttributes();
        this.parseAttributes(attributes);
    }

    public XmlMetaEntity(MappedSuperclass mappedSuperclass, String packageName, TypeElement element, Context context) {
        this.clazzName = mappedSuperclass.getClazz();
        this.packageName = packageName;
        this.context = context;
        this.importContext = new ImportContextImpl(this.getPackageName());
        this.element = element;
        Attributes attributes = mappedSuperclass.getAttributes();
        this.parseAttributes(attributes);
    }

    public XmlMetaEntity(Embeddable embeddable, String packageName, TypeElement element, Context context) {
        XmlMetaCollection metaCollection;
        String[] types;
        XmlMetaSingleAttribute attribute;
        this.clazzName = embeddable.getClazz();
        this.packageName = packageName;
        this.context = context;
        this.importContext = new ImportContextImpl(this.getPackageName());
        this.element = element;
        EmbeddableAttributes attributes = embeddable.getAttributes();
        for (Basic basic : attributes.getBasic()) {
            attribute = new XmlMetaSingleAttribute(this, basic.getName(), this.getType(basic.getName(), null));
            this.members.add(attribute);
        }
        for (ManyToOne manyToOne : attributes.getManyToOne()) {
            attribute = new XmlMetaSingleAttribute(this, manyToOne.getName(), this.getType(manyToOne.getName(), manyToOne.getTargetEntity()));
            this.members.add(attribute);
        }
        for (OneToOne oneToOne : attributes.getOneToOne()) {
            attribute = new XmlMetaSingleAttribute(this, oneToOne.getName(), this.getType(oneToOne.getName(), oneToOne.getTargetEntity()));
            this.members.add(attribute);
        }
        for (OneToMany oneToMany : attributes.getOneToMany()) {
            types = this.getCollectionType(oneToMany.getName(), oneToMany.getTargetEntity());
            metaCollection = new XmlMetaCollection(this, oneToMany.getName(), types[0], types[1]);
            this.members.add(metaCollection);
        }
        for (ElementCollection collection : attributes.getElementCollection()) {
            types = this.getCollectionType(collection.getName(), collection.getTargetClass());
            metaCollection = new XmlMetaCollection(this, collection.getName(), types[0], types[1]);
            this.members.add(metaCollection);
        }
    }

    @Override
    public String getSimpleName() {
        return this.clazzName;
    }

    @Override
    public String getQualifiedName() {
        return this.packageName + "." + this.getSimpleName();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public List<MetaAttribute> getMembers() {
        return this.members;
    }

    @Override
    public String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public String importType(String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public String staticImport(String fqcn, String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public String importType(Name qualifiedName) {
        return this.importType(qualifiedName.toString());
    }

    @Override
    public TypeElement getTypeElement() {
        return this.element;
    }

    private String[] getCollectionType(String propertyName, String explicitTargetEntity) {
        String[] types = new String[2];
        for (Element element : this.element.getEnclosedElements()) {
            if (!element.getSimpleName().toString().equals(propertyName)) continue;
            DeclaredType type = (DeclaredType)element.asType();
            types[0] = explicitTargetEntity == null ? TypeUtils.extractClosestRealTypeAsString(type.getTypeArguments().get(0), this.context) : explicitTargetEntity;
            types[1] = COLLECTIONS.get(type.asElement().toString());
        }
        return types;
    }

    private String getType(String propertyName, String explicitTargetEntity) {
        if (explicitTargetEntity != null) {
            return explicitTargetEntity;
        }
        String typeName = null;
        for (Element element : this.element.getEnclosedElements()) {
            if (!element.getSimpleName().toString().equals(propertyName)) continue;
            switch (element.asType().getKind()) {
                case INT: {
                    typeName = "java.lang.Integer";
                    break;
                }
                case LONG: {
                    typeName = "java.lang.Long";
                    break;
                }
                case BOOLEAN: {
                    typeName = "java.lang.Boolean";
                    break;
                }
                case DECLARED: {
                    typeName = ((Object)element.asType()).toString();
                    break;
                }
                case TYPEVAR: {
                    typeName = ((Object)element.asType()).toString();
                }
            }
            break;
        }
        return typeName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XmlMetaEntity");
        sb.append("{type=").append(this.element);
        sb.append('}');
        return sb.toString();
    }

    private void parseAttributes(Attributes attributes) {
        XmlMetaCollection metaCollection;
        String[] types;
        XmlMetaSingleAttribute attribute;
        if (!attributes.getId().isEmpty()) {
            Id id = attributes.getId().get(0);
            attribute = new XmlMetaSingleAttribute(this, id.getName(), this.getType(id.getName(), null));
            this.members.add(attribute);
        }
        for (Basic basic : attributes.getBasic()) {
            attribute = new XmlMetaSingleAttribute(this, basic.getName(), this.getType(basic.getName(), null));
            this.members.add(attribute);
        }
        for (ManyToOne manyToOne : attributes.getManyToOne()) {
            attribute = new XmlMetaSingleAttribute(this, manyToOne.getName(), this.getType(manyToOne.getName(), manyToOne.getTargetEntity()));
            this.members.add(attribute);
        }
        for (OneToOne oneToOne : attributes.getOneToOne()) {
            attribute = new XmlMetaSingleAttribute(this, oneToOne.getName(), this.getType(oneToOne.getName(), oneToOne.getTargetEntity()));
            this.members.add(attribute);
        }
        for (OneToMany oneToMany : attributes.getOneToMany()) {
            types = this.getCollectionType(oneToMany.getName(), oneToMany.getTargetEntity());
            metaCollection = new XmlMetaCollection(this, oneToMany.getName(), types[0], types[1]);
            this.members.add(metaCollection);
        }
        for (ElementCollection collection : attributes.getElementCollection()) {
            types = this.getCollectionType(collection.getName(), collection.getTargetClass());
            metaCollection = new XmlMetaCollection(this, collection.getName(), types[0], types[1]);
            this.members.add(metaCollection);
        }
    }

    static {
        COLLECTIONS.put("java.util.Collection", "javax.persistence.metamodel.CollectionAttribute");
        COLLECTIONS.put("java.util.Set", "javax.persistence.metamodel.SetAttribute");
        COLLECTIONS.put("java.util.List", "javax.persistence.metamodel.ListAttribute");
        COLLECTIONS.put("java.util.Map", "javax.persistence.metamodel.MapAttribute");
    }
}

