/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.xml.XmlMetaEntity;
import org.hibernate.jpamodelgen.xml.jaxb.AccessType;
import org.hibernate.jpamodelgen.xml.jaxb.Embeddable;
import org.hibernate.jpamodelgen.xml.jaxb.Entity;
import org.hibernate.jpamodelgen.xml.jaxb.EntityMappings;
import org.hibernate.jpamodelgen.xml.jaxb.MappedSuperclass;
import org.hibernate.jpamodelgen.xml.jaxb.ObjectFactory;
import org.hibernate.jpamodelgen.xml.jaxb.Persistence;
import org.hibernate.jpamodelgen.xml.jaxb.PersistenceUnitDefaults;
import org.hibernate.jpamodelgen.xml.jaxb.PersistenceUnitMetadata;
import org.xml.sax.SAXException;

public class XmlParser {
    private static final String PERSISTENCE_XML = "/META-INF/persistence.xml";
    private static final String ORM_XML = "/META-INF/orm.xml";
    private static final String PERSISTENCE_XML_XSD = "persistence_2_0.xsd";
    private static final String ORM_XSD = "orm_2_0.xsd";
    private static final String PATH_SEPARATOR = "/";
    private static final javax.persistence.AccessType DEFAULT_XML_ACCESS_TYPE = javax.persistence.AccessType.PROPERTY;
    private Context context;

    public XmlParser(Context context) {
        this.context = context;
    }

    public void parsePersistenceXml() {
        Persistence persistence = this.parseXml(PERSISTENCE_XML, Persistence.class, PERSISTENCE_XML_XSD);
        if (persistence != null) {
            List<Persistence.PersistenceUnit> persistenceUnits = persistence.getPersistenceUnit();
            for (Persistence.PersistenceUnit unit : persistenceUnits) {
                List<String> mappingFiles = unit.getMappingFile();
                for (String mappingFile : mappingFiles) {
                    this.parsingOrmXml(mappingFile);
                }
            }
        }
        this.parsingOrmXml(ORM_XML);
    }

    private void parsingOrmXml(String resource) {
        EntityMappings mappings = this.parseXml(resource, EntityMappings.class, ORM_XSD);
        if (mappings == null) {
            return;
        }
        javax.persistence.AccessType accessType = this.determineGlobalAccessType(mappings);
        this.parseEntities(mappings, accessType);
        this.parseEmbeddable(mappings, accessType);
        this.parseMappedSuperClass(mappings, accessType);
    }

    private void parseEntities(EntityMappings mappings, javax.persistence.AccessType accessType) {
        String packageName = mappings.getPackage();
        List<Entity> entities = mappings.getEntity();
        for (Entity entity : entities) {
            String fullyQualifiedClassName = packageName + "." + entity.getClazz();
            if (!this.xmlMappedTypeExists(fullyQualifiedClassName)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fullyQualifiedClassName + " is mapped in xml, but class does not exists. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(entity, packageName, this.getXmlMappedType(fullyQualifiedClassName), this.context);
            if (this.context.getMetaEntitiesToProcess().containsKey(fullyQualifiedClassName)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fullyQualifiedClassName + " was already processed once. Skipping second occurance.");
            }
            this.context.getMetaEntitiesToProcess().put(fullyQualifiedClassName, metaEntity);
        }
    }

    private void parseEmbeddable(EntityMappings mappings, javax.persistence.AccessType accessType) {
        String packageName = mappings.getPackage();
        List<Embeddable> embeddables = mappings.getEmbeddable();
        for (Embeddable embeddable : embeddables) {
            String fullyQualifiedClassName = packageName + "." + embeddable.getClazz();
            if (!this.xmlMappedTypeExists(fullyQualifiedClassName)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fullyQualifiedClassName + " is mapped in xml, but class does not exists. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(embeddable, packageName, this.getXmlMappedType(fullyQualifiedClassName), this.context);
            if (this.context.getMetaSuperclassAndEmbeddableToProcess().containsKey(fullyQualifiedClassName)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fullyQualifiedClassName + " was already processed once. Skipping second occurance.");
            }
            this.context.getMetaSuperclassAndEmbeddableToProcess().put(fullyQualifiedClassName, metaEntity);
        }
    }

    private void parseMappedSuperClass(EntityMappings mappings, javax.persistence.AccessType accessType) {
        String packageName = mappings.getPackage();
        List<MappedSuperclass> mappedSuperClasses = mappings.getMappedSuperclass();
        for (MappedSuperclass mappedSuperClass : mappedSuperClasses) {
            String fullyQualifiedClassName = packageName + "." + mappedSuperClass.getClazz();
            if (!this.xmlMappedTypeExists(fullyQualifiedClassName)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fullyQualifiedClassName + " is mapped in xml, but class does not exists. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(mappedSuperClass, packageName, this.getXmlMappedType(fullyQualifiedClassName), this.context);
            if (this.context.getMetaSuperclassAndEmbeddableToProcess().containsKey(fullyQualifiedClassName)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fullyQualifiedClassName + " was already processed once. Skipping second occurance.");
            }
            this.context.getMetaSuperclassAndEmbeddableToProcess().put(fullyQualifiedClassName, metaEntity);
        }
    }

    private <T> T parseXml(String resource, Class<T> clazz, String schemaName) {
        InputStream stream = this.getInputStreamForResource(resource);
        if (stream == null) {
            this.context.logMessage(Diagnostic.Kind.OTHER, resource + " not found.");
            return null;
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            if (schemaName != null) {
                unmarshaller.setSchema(this.getSchema(schemaName));
            }
            return clazz.cast(unmarshaller.unmarshal(stream));
        }
        catch (JAXBException e) {
            String message = "Error unmarshalling " + resource + " with exception :\n " + (Object)((Object)e);
            this.context.logMessage(Diagnostic.Kind.WARNING, message);
            return null;
        }
        catch (Exception e) {
            String message = "Error reading " + resource + " with exception :\n " + e;
            this.context.logMessage(Diagnostic.Kind.WARNING, message);
            return null;
        }
    }

    private Schema getSchema(String schemaName) {
        Schema schema = null;
        URL schemaUrl = this.getClass().getClassLoader().getResource(schemaName);
        if (schemaUrl == null) {
            return schema;
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schema = sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to create schema for " + schemaName + ": " + e.getMessage());
        }
        return schema;
    }

    private InputStream getInputStreamForResource(String resource) {
        InputStream ormStream;
        String pkg = this.getPackage(resource);
        String name = this.getRelativeName(resource);
        this.context.logMessage(Diagnostic.Kind.OTHER, "Reading resource " + resource);
        try {
            FileObject fileObject = this.context.getProcessingEnvironment().getFiler().getResource(StandardLocation.CLASS_OUTPUT, pkg, name);
            ormStream = fileObject.openInputStream();
        }
        catch (IOException e1) {
            ormStream = this.getClass().getResourceAsStream(resource);
        }
        return ormStream;
    }

    private String getPackage(String resourceName) {
        if (!resourceName.contains(PATH_SEPARATOR)) {
            return "";
        }
        return resourceName.substring(0, resourceName.lastIndexOf(PATH_SEPARATOR));
    }

    private String getRelativeName(String resourceName) {
        if (!resourceName.contains(PATH_SEPARATOR)) {
            return resourceName;
        }
        return resourceName.substring(resourceName.lastIndexOf(PATH_SEPARATOR) + 1);
    }

    private boolean xmlMappedTypeExists(String fullyQualifiedClassName) {
        Elements utils = this.context.getProcessingEnvironment().getElementUtils();
        return utils.getTypeElement(fullyQualifiedClassName) != null;
    }

    private TypeElement getXmlMappedType(String fullyQualifiedClassName) {
        Elements utils = this.context.getProcessingEnvironment().getElementUtils();
        return utils.getTypeElement(fullyQualifiedClassName);
    }

    private javax.persistence.AccessType determineGlobalAccessType(EntityMappings mappings) {
        AccessType xmlAccessType;
        PersistenceUnitDefaults persistenceUnitDefaults;
        javax.persistence.AccessType accessType = DEFAULT_XML_ACCESS_TYPE;
        if (mappings.getAccess() != null) {
            accessType = this.mapXmlAccessTypeToJpaAccessType(mappings.getAccess());
            return accessType;
        }
        PersistenceUnitMetadata meta = mappings.getPersistenceUnitMetadata();
        if (meta != null && (persistenceUnitDefaults = meta.getPersistenceUnitDefaults()) != null && (xmlAccessType = persistenceUnitDefaults.getAccess()) != null) {
            accessType = this.mapXmlAccessTypeToJpaAccessType(xmlAccessType);
        }
        return accessType;
    }

    private javax.persistence.AccessType mapXmlAccessTypeToJpaAccessType(AccessType xmlAccessType) {
        switch (xmlAccessType) {
            case FIELD: {
                return javax.persistence.AccessType.FIELD;
            }
            case PROPERTY: {
                return javax.persistence.AccessType.PROPERTY;
            }
        }
        return null;
    }
}

