/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// $Id: XmlMetaCollection.java 20786 2010-10-07 12:22:12Z hardy.ferentschik $

package org.hibernate.jpamodelgen.xml;

import org.hibernate.jpamodelgen.model.MetaCollection;

/**
 * @author Hardy Ferentschik
 */
public class XmlMetaCollection extends XmlMetaAttribute implements MetaCollection {

    private String collectionType;

    public XmlMetaCollection(XmlMetaEntity parent, String propertyName, String type, String collectionType) {
        super(parent, propertyName, type);
        this.collectionType = collectionType;
    }

    @Override
	public String getMetaType() {
		return collectionType;
	}
}