/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Properties;
import javax.persistence.spi.PersistenceProvider;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class HibernateBundleActivator
implements BundleActivator,
BundleListener {
    private OsgiClassLoader osgiClassLoader;

    public void start(BundleContext context) throws Exception {
        context.addBundleListener((BundleListener)this);
        this.osgiClassLoader = new OsgiClassLoader();
        ClassLoaderHelper.overridenClassLoader = this.osgiClassLoader;
        for (Bundle bundle : context.getBundles()) {
            this.handleBundleChange(bundle);
        }
        HibernatePersistence hp = new HibernatePersistence();
        HashMap<String, OsgiJtaPlatform> map = new HashMap<String, OsgiJtaPlatform>();
        map.put("hibernate.transaction.jta.platform", new OsgiJtaPlatform(context));
        hp.setEnvironmentProperties(map);
        Properties properties = new Properties();
        properties.put("javax.persistence.provider", HibernatePersistence.class.getName());
        context.registerService(PersistenceProvider.class.getName(), (Object)hp, (Dictionary)properties);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        this.handleBundleChange(event.getBundle());
    }

    private void handleBundleChange(Bundle bundle) {
        if (bundle.getState() == 32) {
            this.osgiClassLoader.registerBundle(bundle);
        } else {
            this.osgiClassLoader.unregisterBundle(bundle);
        }
    }
}

