/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.StringHelper;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.JAXPConfigurator;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxoolConnectionProvider
implements ConnectionProvider {
    private static final String PROXOOL_JDBC_STEM = "proxool.";
    private static final Logger log = LoggerFactory.getLogger((Class)ProxoolConnectionProvider.class);
    private String proxoolAlias;
    private boolean existingPool;
    private Integer isolation;
    private boolean autocommit;

    public Connection getConnection() throws SQLException {
        Connection c = DriverManager.getConnection(this.proxoolAlias);
        if (this.isolation != null) {
            c.setTransactionIsolation(this.isolation);
        }
        if (c.getAutoCommit() != this.autocommit) {
            c.setAutoCommit(this.autocommit);
        }
        return c;
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void configure(Properties props) throws HibernateException {
        String jaxpFile = props.getProperty("hibernate.proxool.xml");
        String propFile = props.getProperty("hibernate.proxool.properties");
        String externalConfig = props.getProperty("hibernate.proxool.existing_pool");
        this.proxoolAlias = props.getProperty("hibernate.proxool.pool_alias");
        if ("true".equals(externalConfig)) {
            if (!StringHelper.isNotEmpty((String)this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use an existing in memory pool without the hibernate.proxool.pool_alias property set.";
                log.error(msg);
                throw new HibernateException(msg);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            this.existingPool = true;
            log.info("Configuring Proxool Provider using existing pool in memory: " + this.proxoolAlias);
        } else if (StringHelper.isNotEmpty((String)jaxpFile)) {
            log.info("Configuring Proxool Provider using JAXPConfigurator: " + jaxpFile);
            if (!StringHelper.isNotEmpty((String)this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use JAXP without the hibernate.proxool.pool_alias property set.";
                log.error(msg);
                throw new HibernateException(msg);
            }
            try {
                JAXPConfigurator.configure((Reader)ConfigHelper.getConfigStreamReader((String)jaxpFile), (boolean)false);
            }
            catch (ProxoolException e) {
                String msg = "Proxool Provider unable to load JAXP configurator file: " + jaxpFile;
                log.error(msg, (Throwable)e);
                throw new HibernateException(msg, (Throwable)e);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            log.info("Configuring Proxool Provider to use pool alias: " + this.proxoolAlias);
        } else if (StringHelper.isNotEmpty((String)propFile)) {
            log.info("Configuring Proxool Provider using Properties File: " + propFile);
            if (!StringHelper.isNotEmpty((String)this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use Properties File without the hibernate.proxool.pool_alias property set.";
                log.error(msg);
                throw new HibernateException(msg);
            }
            try {
                PropertyConfigurator.configure((Properties)ConfigHelper.getConfigProperties((String)propFile));
            }
            catch (ProxoolException e) {
                String msg = "Proxool Provider unable to load load Property configurator file: " + propFile;
                log.error(msg, (Throwable)e);
                throw new HibernateException(msg, (Throwable)e);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            log.info("Configuring Proxool Provider to use pool alias: " + this.proxoolAlias);
        }
        this.isolation = PropertiesHelper.getInteger((String)"hibernate.connection.isolation", (Properties)props);
        if (this.isolation != null) {
            log.info("JDBC isolation level: " + Environment.isolationLevelToString((int)this.isolation));
        }
        this.autocommit = PropertiesHelper.getBoolean((String)"hibernate.connection.autocommit", (Properties)props);
        log.info("autocommit mode: " + this.autocommit);
    }

    public void close() throws HibernateException {
        if (this.existingPool) {
            return;
        }
        try {
            ProxoolFacade.shutdown((int)0);
        }
        catch (Exception e) {
            log.warn("Exception occured when closing the Proxool pool", (Throwable)e);
            throw new HibernateException("Exception occured when closing the Proxool pool", (Throwable)e);
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

