/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.WordDelimiterFilter;
import org.apache.solr.analysis.WordDelimiterIterator;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordDelimiterFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    public static final String PROTECTED_TOKENS = "protected";
    public static final String TYPES = "types";
    private CharArraySet protectedWords = null;
    int generateWordParts = 0;
    int generateNumberParts = 0;
    int catenateWords = 0;
    int catenateNumbers = 0;
    int catenateAll = 0;
    int splitOnCaseChange = 0;
    int splitOnNumerics = 0;
    int preserveOriginal = 0;
    int stemEnglishPossessive = 0;
    byte[] typeTable = null;
    private static Pattern typePattern = Pattern.compile("(.*)\\s*=>\\s*(.*)\\s*$");
    char[] out = new char[256];

    @Override
    public void inform(ResourceLoader loader) {
        String types;
        String wordFiles = (String)this.args.get(PROTECTED_TOKENS);
        if (wordFiles != null) {
            try {
                this.protectedWords = this.getWordSet(loader, wordFiles, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((types = (String)this.args.get(TYPES)) != null) {
            try {
                List<String> files = StrUtils.splitFileNames(types);
                ArrayList<String> wlist = new ArrayList<String>();
                for (String file : files) {
                    List<String> lines = loader.getLines(file.trim());
                    wlist.addAll(lines);
                }
                this.typeTable = this.parseTypes(wlist);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        this.generateWordParts = this.getInt("generateWordParts", 1);
        this.generateNumberParts = this.getInt("generateNumberParts", 1);
        this.catenateWords = this.getInt("catenateWords", 0);
        this.catenateNumbers = this.getInt("catenateNumbers", 0);
        this.catenateAll = this.getInt("catenateAll", 0);
        this.splitOnCaseChange = this.getInt("splitOnCaseChange", 1);
        this.splitOnNumerics = this.getInt("splitOnNumerics", 1);
        this.preserveOriginal = this.getInt("preserveOriginal", 0);
        this.stemEnglishPossessive = this.getInt("stemEnglishPossessive", 1);
    }

    public WordDelimiterFilter create(TokenStream input) {
        return new WordDelimiterFilter(input, this.typeTable == null ? WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE : this.typeTable, this.generateWordParts, this.generateNumberParts, this.catenateWords, this.catenateNumbers, this.catenateAll, this.splitOnCaseChange, this.preserveOriginal, this.splitOnNumerics, this.stemEnglishPossessive, this.protectedWords);
    }

    private byte[] parseTypes(List<String> rules) {
        TreeMap<Character, Byte> typeMap = new TreeMap<Character, Byte>();
        for (String rule : rules) {
            Matcher m = typePattern.matcher(rule);
            if (!m.find()) {
                throw new RuntimeException("Invalid Mapping Rule : [" + rule + "]");
            }
            String lhs = this.parseString(m.group(1).trim());
            Byte rhs = this.parseType(m.group(2).trim());
            if (lhs.length() != 1) {
                throw new RuntimeException("Invalid Mapping Rule : [" + rule + "]. Only a single character is allowed.");
            }
            if (rhs == null) {
                throw new RuntimeException("Invalid Mapping Rule : [" + rule + "]. Illegal type.");
            }
            typeMap.put(Character.valueOf(lhs.charAt(0)), rhs);
        }
        byte[] types = new byte[Math.max(((Character)typeMap.lastKey()).charValue() + '\u0001', WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE.length)];
        for (int i = 0; i < types.length; ++i) {
            types[i] = WordDelimiterIterator.getType(i);
        }
        for (Map.Entry mapping : typeMap.entrySet()) {
            types[((Character)mapping.getKey()).charValue()] = (Byte)mapping.getValue();
        }
        return types;
    }

    private Byte parseType(String s) {
        if (s.equals("LOWER")) {
            return (byte)1;
        }
        if (s.equals("UPPER")) {
            return (byte)2;
        }
        if (s.equals("ALPHA")) {
            return (byte)3;
        }
        if (s.equals("DIGIT")) {
            return (byte)4;
        }
        if (s.equals("ALPHANUM")) {
            return (byte)7;
        }
        if (s.equals("SUBWORD_DELIM")) {
            return (byte)8;
        }
        return null;
    }

    private String parseString(String s) {
        int readPos = 0;
        int len = s.length();
        int writePos = 0;
        while (readPos < len) {
            int c;
            if ((c = s.charAt(readPos++)) == 92) {
                if (readPos >= len) {
                    throw new RuntimeException("Invalid escaped char in [" + s + "]");
                }
                c = s.charAt(readPos++);
                switch (c) {
                    case 92: {
                        c = 92;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 117: {
                        if (readPos + 3 >= len) {
                            throw new RuntimeException("Invalid escaped char in [" + s + "]");
                        }
                        c = (char)Integer.parseInt(s.substring(readPos, readPos + 4), 16);
                        readPos += 4;
                    }
                }
            }
            this.out[writePos++] = c;
        }
        return new String(this.out, 0, writePos);
    }
}

