/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.jgroups.impl.JGroupsBackend;
import org.hibernate.search.backend.jgroups.impl.JGroupsBackendQueueProcessor;
import org.hibernate.search.backend.jgroups.impl.JGroupsMasterBackend;
import org.hibernate.search.backend.spi.Backend;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class JGroupsReceivingMockBackend
implements Backend {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private final JGroupsBackend delegate = new JGroupsMasterBackend();

    public void initialize(Properties properties, WorkerBuildContext context) {
        this.delegate.initialize(properties, context);
    }

    public void close() {
        this.delegate.close();
    }

    public BackendQueueProcessor createQueueProcessor(IndexManager indexManager, WorkerBuildContext context) {
        return new JGroupsReceivingMockBackendQueueProcessor(this.delegate.createQueueProcessor(indexManager, context));
    }

    public static class JGroupsReceivingMockBackendQueueProcessor
    implements BackendQueueProcessor {
        private final JGroupsBackendQueueProcessor delegate;
        private volatile CountDownLatch threadTrap;
        private volatile boolean failOnMessage = false;
        private volatile boolean receivedAnything = false;

        public JGroupsReceivingMockBackendQueueProcessor(JGroupsBackendQueueProcessor delegate) {
            this.delegate = delegate;
        }

        public void close() {
            this.delegate.close();
        }

        public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
            this.receivedSomething();
            this.countDownAndJoin();
        }

        private void receivedSomething() {
            System.out.println(" ************** Received something! *****************");
            this.receivedAnything = true;
        }

        public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
            this.receivedSomething();
            this.countDownAndJoin();
        }

        public JGroupsBackendQueueProcessor getDelegate() {
            return this.delegate;
        }

        public void resetThreadTrap() {
            this.threadTrap = new CountDownLatch(2);
        }

        public boolean wasSomethingReceived() {
            return this.receivedAnything;
        }

        public void countDownAndJoin() {
            if (this.failOnMessage) {
                throw new NullPointerException("Simulated Failure");
            }
            log.trace((Object)("[PREJOIN] Timestamp: " + System.nanoTime()));
            try {
                this.threadTrap.countDown();
                this.threadTrap.await(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
            log.trace((Object)("[POSTJOIN] Timestamp: " + System.nanoTime()));
        }

        public int releaseBlockedThreads() {
            int count = (int)this.threadTrap.getCount();
            for (int i = 0; i < count; ++i) {
                this.threadTrap.countDown();
            }
            return count;
        }

        public void induceFailure() {
            this.failOnMessage = true;
        }
    }
}

