/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.slave;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.backend.jgroups.impl.MessageListenerToRequestHandlerAdapter;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.jgroups.common.JGroupsCommonTest;
import org.hibernate.search.test.jgroups.slave.JGroupsReceiver;
import org.hibernate.search.test.jgroups.slave.TShirt;
import org.hibernate.search.testsupport.concurrency.Poller;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.jgroups.JChannel;
import org.jgroups.MessageListener;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JGroupsSlaveTest
extends SearchTestBase {
    private static final Poller POLLER = JGroupsCommonTest.POLLER;
    private JChannel channel;
    private final String CHANNEL_NAME = UUID.randomUUID().toString();

    @Test
    public void testMessageSend() throws Exception {
        TShirt ts;
        Transaction tx;
        JGroupsReceiver.reset();
        try (Session s = this.openSession();){
            tx = s.beginTransaction();
            ts = new TShirt();
            ts.setLogo("Boston");
            ts.setSize("XXL");
            ts.setLength(23.3);
            TShirt ts2 = new TShirt();
            ts2.setLogo("Mapple leaves");
            ts2.setSize("L");
            ts2.setLength(23.32);
            s.persist((Object)ts);
            s.persist((Object)ts2);
            tx.commit();
            POLLER.pollAssertion(() -> Assert.assertTrue((String)"Message not received after waiting for long!", (JGroupsReceiver.queues == 1 && JGroupsReceiver.works == 2 ? 1 : 0) != 0));
        }
        JGroupsReceiver.reset();
        s = this.openSession();
        var3_2 = null;
        try {
            tx = s.beginTransaction();
            ts = (TShirt)s.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId()));
            ts.setLogo("Peter pan");
            tx.commit();
            POLLER.pollAssertion(() -> Assert.assertTrue((String)"Message not received after waiting for long!", (JGroupsReceiver.queues == 1 && JGroupsReceiver.works == 1 ? 1 : 0) != 0));
        }
        catch (Throwable tx2) {
            var3_2 = tx2;
            throw tx2;
        }
        finally {
            if (s != null) {
                if (var3_2 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable tx2) {
                        var3_2.addSuppressed(tx2);
                    }
                } else {
                    s.close();
                }
            }
        }
        JGroupsReceiver.reset();
        s = this.openSession();
        var3_2 = null;
        try {
            tx = s.beginTransaction();
            s.delete(s.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId())));
            tx.commit();
            POLLER.pollAssertion(() -> Assert.assertTrue((String)"Message not received after waiting for long!", (JGroupsReceiver.queues == 1 && JGroupsReceiver.works == 1 ? 1 : 0) != 0));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var3_2 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
    }

    private void prepareJGroupsChannel() throws Exception {
        this.channel = new JChannel(ConfigurationParseHelper.locateConfig((String)"testing-flush-loopback.xml"));
        this.channel.connect(this.CHANNEL_NAME);
        JGroupsReceiver listener = new JGroupsReceiver((SearchIntegrator)this.getExtendedSearchIntegrator());
        MessageListenerToRequestHandlerAdapter adapter = new MessageListenerToRequestHandlerAdapter((MessageListener)listener);
        MessageDispatcher standardDispatcher = new MessageDispatcher(this.channel, (RequestHandler)adapter);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.prepareJGroupsChannel();
    }

    @After
    public void tearDown() throws Exception {
        this.channel.close();
        super.tearDown();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }

    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.worker.backend", "jgroupsSlave");
        cfg.put("hibernate.search.default.block_waiting_ack", "false");
        cfg.put("hibernate.search.default.messages_timeout", "100");
        cfg.put("hibernate.search.services.jgroups.clusterName", this.CHANNEL_NAME);
        cfg.put("hibernate.search.services.jgroups.configurationFile", "testing-flush-loopback.xml");
    }
}

