/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.slave;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.backend.jgroups.impl.MessageListenerToRequestHandlerAdapter;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.jgroups.slave.JGroupsReceiver;
import org.hibernate.search.test.jgroups.slave.TShirt;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MessageListener;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JGroupsSlaveTest
extends SearchTestBase {
    private Channel channel;
    private final String CHANNEL_NAME = UUID.randomUUID().toString();

    @Test
    public void testMessageSend() throws Exception {
        int i;
        boolean failed;
        TShirt ts;
        Transaction tx;
        JGroupsReceiver.reset();
        try (Session s = this.openSession();){
            tx = s.beginTransaction();
            ts = new TShirt();
            ts.setLogo("Boston");
            ts.setSize("XXL");
            ts.setLength(23.3);
            TShirt ts2 = new TShirt();
            ts2.setLogo("Mapple leaves");
            ts2.setSize("L");
            ts2.setLength(23.32);
            s.persist((Object)ts);
            s.persist((Object)ts2);
            tx.commit();
            boolean failed2 = true;
            for (int i2 = 0; i2 < 100; ++i2) {
                Thread.sleep(100L);
                if (JGroupsReceiver.queues != 1 || JGroupsReceiver.works != 2) continue;
                failed2 = false;
                break;
            }
            if (failed2) {
                Assert.fail((String)"Message not received after waiting for long!");
            }
        }
        JGroupsReceiver.reset();
        s = this.openSession();
        var3_2 = null;
        try {
            tx = s.beginTransaction();
            ts = (TShirt)s.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId()));
            ts.setLogo("Peter pan");
            tx.commit();
            failed = true;
            for (i = 0; i < 100; ++i) {
                Thread.sleep(100L);
                if (JGroupsReceiver.queues != 1 || JGroupsReceiver.works != 1) continue;
                failed = false;
                break;
            }
            if (failed) {
                Assert.fail((String)"Message not received after waiting for long!");
            }
        }
        catch (Throwable x2) {
            var3_2 = x2;
            throw x2;
        }
        finally {
            if (s != null) {
                if (var3_2 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable x2) {
                        var3_2.addSuppressed(x2);
                    }
                } else {
                    s.close();
                }
            }
        }
        JGroupsReceiver.reset();
        s = this.openSession();
        var3_2 = null;
        try {
            tx = s.beginTransaction();
            s.delete(s.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId())));
            tx.commit();
            failed = true;
            for (i = 0; i < 100; ++i) {
                Thread.sleep(100L);
                if (JGroupsReceiver.queues != 1 || JGroupsReceiver.works != 1) continue;
                failed = false;
                break;
            }
            if (failed) {
                Assert.fail((String)"Message not received after waiting for long!");
            }
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var3_2 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable x2) {
                        var3_2.addSuppressed(x2);
                    }
                } else {
                    s.close();
                }
            }
        }
    }

    private void prepareJGroupsChannel() throws Exception {
        this.channel = new JChannel(ConfigurationParseHelper.locateConfig((String)"testing-flush-loopback.xml"));
        this.channel.connect(this.CHANNEL_NAME);
        JGroupsReceiver listener = new JGroupsReceiver((SearchIntegrator)this.getExtendedSearchIntegrator());
        MessageListenerToRequestHandlerAdapter adapter = new MessageListenerToRequestHandlerAdapter((MessageListener)listener);
        MessageDispatcher standardDispatcher = new MessageDispatcher(this.channel, (MessageListener)listener, (MembershipListener)listener, (RequestHandler)adapter);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.prepareJGroupsChannel();
    }

    @After
    public void tearDown() throws Exception {
        this.channel.close();
        super.tearDown();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }

    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.worker.backend", "jgroupsSlave");
        cfg.put("hibernate.search.default.block_waiting_ack", "false");
        cfg.put("hibernate.search.default.messages_timeout", "100");
        cfg.put("hibernate.search.services.jgroups.clusterName", this.CHANNEL_NAME);
        cfg.put("hibernate.search.services.jgroups.configurationFile", "testing-flush-loopback.xml");
    }
}

