/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import java.util.Map;
import java.util.Random;
import org.hibernate.search.backend.jgroups.impl.MessageSenderService;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.jgroups.common.JGroupsCommonTest;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.jgroups.JChannel;
import org.jgroups.UpHandler;
import org.jgroups.blocks.mux.MuxUpHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class MuxChannelTest
extends JGroupsCommonTest {
    private JChannel[] channels;
    private short muxId;

    @Test
    public void testMuxDispatcher() throws Exception {
        SearchIntegrator integrator = (SearchIntegrator)this.getSearchFactory().unwrap(SearchIntegrator.class);
        MessageSenderService sender = (MessageSenderService)integrator.getServiceManager().requestService(MessageSenderService.class);
        Assert.assertNotNull((Object)sender);
        String className = sender.getClass().getName();
        Assert.assertTrue((String)("Wrong sender instance: " + className), (boolean)className.contains("DispatchMessageSender"));
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.muxId = (short)new Random().nextInt();
        this.channels = this.createChannels();
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @After
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            for (JChannel channel : this.channels) {
                if (channel == null) continue;
                channel.close();
            }
        }
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        super.configure(cfg);
        cfg.put("hibernate.search.default.worker.backend", this.getMasterBackend());
        cfg.put("hibernate.search.services.jgroups.providedChannel", this.channels[0]);
        cfg.put("hibernate.search.services.jgroups.mux_id", this.muxId);
    }

    @Override
    protected void configureSlave(Map<String, Object> cfg) {
        super.configureSlave(cfg);
        cfg.put("hibernate.search.default.worker.backend", this.getSlaveBackend());
        cfg.put("hibernate.search.services.jgroups.providedChannel", this.channels[1]);
        cfg.put("hibernate.search.services.jgroups.mux_id", this.muxId);
    }

    protected JChannel createChannel() throws Exception {
        JChannel channel = new JChannel(ConfigurationParseHelper.locateConfig((String)"testing-flush-loopback.xml"));
        channel.setUpHandler((UpHandler)new MuxUpHandler());
        channel.connect("JGroupsCommonTest" + JGroupsCommonTest.CHANNEL_NAME);
        return channel;
    }

    protected abstract String getMasterBackend();

    protected abstract JChannel[] createChannels() throws Exception;

    protected abstract String getSlaveBackend();
}

