/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.impl.blackhole.BlackHoleBackendQueueProcessor;
import org.hibernate.search.backend.jgroups.impl.JGroupsBackendQueueProcessor;
import org.hibernate.search.backend.jgroups.impl.JGroupsReceivingMockBackend;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.TimeoutException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1296")
public class SyncJGroupsBackendTest {
    private static final Log log = LoggerFactory.make();
    private static final String JGROUPS_CONFIGURATION = "testing-flush-loopback.xml";
    @Rule
    public SearchFactoryHolder slaveNode = new SearchFactoryHolder(new Class[]{Dvd.class, Book.class, Drink.class, Star.class}).withProperty("hibernate.search.default.worker.backend", (Object)"jgroupsSlave").withProperty("hibernate.search.dvds.worker.execution", (Object)"sync").withProperty("hibernate.search.dvds.jgroups.messages_timeout", (Object)"200").withProperty("hibernate.search.books.worker.execution", (Object)"async").withProperty("hibernate.search.drinks.jgroups.block_waiting_ack", (Object)"true").withProperty("hibernate.search.stars.jgroups.block_waiting_ack", (Object)"false").withProperty("hibernate.search.services.jgroups.configurationFile", (Object)"testing-flush-loopback.xml");
    @Rule
    public SearchFactoryHolder masterNode = new SearchFactoryHolder(new Class[]{Dvd.class, Book.class, Drink.class, Star.class}).withProperty("hibernate.search.default.worker.backend", (Object)JGroupsReceivingMockBackend.class.getName()).withProperty("hibernate.search.dvds.jgroups.delegate_backend", (Object)"blackhole").withProperty("hibernate.search.services.jgroups.configurationFile", (Object)"testing-flush-loopback.xml");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchAsConfigured() {
        JGroupsBackendQueueProcessor dvdsBackend = this.extractJGroupsBackend("dvds");
        Assert.assertTrue((String)"dvds index was configured with a syncronous JGroups backend", (boolean)dvdsBackend.blocksForACK());
        JGroupsBackendQueueProcessor booksBackend = this.extractJGroupsBackend("books");
        Assert.assertFalse((String)"books index was configured with an asyncronous JGroups backend", (boolean)booksBackend.blocksForACK());
        JGroupsBackendQueueProcessor drinksBackend = this.extractJGroupsBackend("drinks");
        Assert.assertTrue((String)"drinks index was configured with a syncronous JGroups backend", (boolean)drinksBackend.blocksForACK());
        JGroupsBackendQueueProcessor starsBackend = this.extractJGroupsBackend("stars");
        Assert.assertFalse((String)"stars index was configured with an asyncronous JGroups backend", (boolean)starsBackend.blocksForACK());
        JGroupsReceivingMockBackend dvdBackendMock = this.extractMockBackend("dvds");
        dvdBackendMock.resetThreadTrap();
        boolean timeoutTriggered = false;
        try {
            long presendTimestamp = System.nanoTime();
            log.trace((Object)("[PRESEND] Timestamp: " + presendTimestamp));
            this.storeDvd(1, "Hibernate Search in Action");
            long postsendTimestamp = System.nanoTime();
            long differenceInMilliseconds = TimeUnit.MILLISECONDS.convert(postsendTimestamp - presendTimestamp, TimeUnit.NANOSECONDS);
            log.trace((Object)("[POSTSEND] Timestamp: " + postsendTimestamp + " Diff: " + differenceInMilliseconds + " ms."));
        }
        catch (SearchException se) {
            Throwable cause = se.getCause();
            Assert.assertTrue((String)("Cause was not a TimeoutException but a " + cause), (boolean)(cause instanceof TimeoutException));
            timeoutTriggered = true;
        }
        finally {
            dvdBackendMock.releaseBlockedThreads();
        }
        Assert.assertTrue((String)"The backend didn't receive any message: something wrong with the test setup of network configuration", (boolean)dvdBackendMock.wasSomethingReceived());
        Assert.assertTrue((boolean)timeoutTriggered);
        JGroupsReceivingMockBackend booksBackendMock = this.extractMockBackend("books");
        booksBackendMock.resetThreadTrap();
        this.storeBook(1, "Hibernate Search in Action");
        booksBackendMock.countDownAndJoin();
        dvdBackendMock.induceFailure();
        boolean npeTriggered = false;
        try {
            this.storeDvd(2, "Byteman in Action");
        }
        catch (SearchException se) {
            Throwable cause = se.getCause().getCause().getCause();
            Assert.assertTrue((String)("Cause was not a NullPointerException but a " + cause), (boolean)(cause instanceof NullPointerException));
            Assert.assertEquals((Object)"Simulated Failure", (Object)cause.getMessage());
            npeTriggered = true;
        }
        Assert.assertTrue((boolean)npeTriggered);
    }

    @Test
    public void alternativeBackendConfiguration() {
        BackendQueueProcessor backendQueueProcessor = SyncJGroupsBackendTest.extractBackendQueue(this.masterNode, "dvds");
        JGroupsBackendQueueProcessor jgroupsProcessor = (JGroupsBackendQueueProcessor)backendQueueProcessor;
        BackendQueueProcessor delegatedBackend = jgroupsProcessor.getDelegatedBackend();
        Assert.assertTrue((String)"dvds backend was configured with a delegate to blackhole but it's not using it", (boolean)(delegatedBackend instanceof BlackHoleBackendQueueProcessor));
    }

    @Test
    public void alternativeJGroupsTimeoutConfiguration() {
        BackendQueueProcessor backendQueueProcessor = SyncJGroupsBackendTest.extractBackendQueue(this.slaveNode, "dvds");
        JGroupsBackendQueueProcessor jgroupsProcessor = (JGroupsBackendQueueProcessor)backendQueueProcessor;
        long messageTimeout = jgroupsProcessor.getMessageTimeout();
        Assert.assertEquals((String)"message timeout configuration property not applied", (long)200L, (long)messageTimeout);
    }

    private JGroupsReceivingMockBackend extractMockBackend(String indexName) {
        BackendQueueProcessor backendQueueProcessor = SyncJGroupsBackendTest.extractBackendQueue(this.masterNode, indexName);
        Assert.assertTrue((String)"Backend not using the configured Mock!", (boolean)(backendQueueProcessor instanceof JGroupsReceivingMockBackend));
        return (JGroupsReceivingMockBackend)backendQueueProcessor;
    }

    private JGroupsBackendQueueProcessor extractJGroupsBackend(String indexName) {
        BackendQueueProcessor backendQueueProcessor = SyncJGroupsBackendTest.extractBackendQueue(this.slaveNode, indexName);
        Assert.assertTrue((String)"Backend not using JGroups!", (boolean)(backendQueueProcessor instanceof JGroupsBackendQueueProcessor));
        return (JGroupsBackendQueueProcessor)backendQueueProcessor;
    }

    private static BackendQueueProcessor extractBackendQueue(SearchFactoryHolder node, String indexName) {
        IndexManager indexManager = node.getSearchFactory().getIndexManagerHolder().getIndexManager(indexName);
        Assert.assertNotNull((Object)indexManager);
        DirectoryBasedIndexManager dbi = (DirectoryBasedIndexManager)indexManager;
        return dbi.getBackendQueueProcessor();
    }

    private void storeBook(int id, String string) {
        Book book = new Book();
        book.id = id;
        book.title = string;
        this.storeObject(book, Integer.valueOf(id));
    }

    private void storeDvd(int id, String dvdTitle) {
        Dvd dvd1 = new Dvd();
        dvd1.id = id;
        dvd1.title = dvdTitle;
        this.storeObject(dvd1, Integer.valueOf(id));
    }

    private void storeObject(Object entity, Serializable id) {
        Work work = new Work(entity, id, WorkType.UPDATE, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        this.slaveNode.getSearchFactory().getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    @Indexed(index="stars")
    public static final class Star {
        @DocumentId
        long id;
        @Field
        String title;
    }

    @Indexed(index="drinks")
    public static final class Drink {
        @DocumentId
        long id;
        @Field
        String title;
    }

    @Indexed(index="books")
    public static final class Book {
        @DocumentId
        long id;
        @Field
        String title;
    }

    @Indexed(index="dvds")
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }
}

