/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.test.DefaultTestResourceManager;
import org.hibernate.search.test.util.TestConfiguration;
import org.junit.After;
import org.junit.Before;

public abstract class DynamicMasterSlaveSearchTestCase
implements TestConfiguration {
    private String alreadySelectedBaseIndexDir = null;
    private List<DefaultTestResourceManager> resourceManagers = new ArrayList<DefaultTestResourceManager>();

    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.worker.backend", "jgroups");
        cfg.put("hibernate.search.default.directory_provider", "filesystem");
        cfg.put("hibernate.search.default.exclusive_index_use", "false");
        if (this.alreadySelectedBaseIndexDir != null) {
            cfg.put("hibernate.search.default.indexBase", this.alreadySelectedBaseIndexDir);
        }
    }

    public Set<String> multiTenantIds() {
        return Collections.emptySet();
    }

    protected abstract int getExpectedNumberOfNodes();

    @Before
    public void setUp() throws Exception {
        for (int i = 0; i < this.getExpectedNumberOfNodes(); ++i) {
            DefaultTestResourceManager resourceManager = new DefaultTestResourceManager((TestConfiguration)this, this.getClass());
            this.resourceManagers.add(resourceManager);
            resourceManager.openSessionFactory();
            if (this.alreadySelectedBaseIndexDir != null) continue;
            this.alreadySelectedBaseIndexDir = resourceManager.getBaseIndexDir().toAbsolutePath().toString();
        }
    }

    @After
    public void tearDown() throws Exception {
        for (DefaultTestResourceManager resourceManager : this.resourceManagers) {
            resourceManager.defaultTearDown();
        }
    }

    public List<DefaultTestResourceManager> getResourceManagers() {
        return this.resourceManagers;
    }
}

