/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JGroupsConfigurationTest {
    @Rule
    public ExpectedException error = ExpectedException.none();
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();

    @Test
    public void refuseConfigurationFileOnDefaultIndex() throws Throwable {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().addProperty("hibernate.search.default.worker.backend", "jgroupsMaster").addProperty("hibernate.search.default.worker.backend.jgroups.configurationFile", "some non existing file");
        this.error.expect(SearchException.class);
        this.error.expectMessage("JGroups channel configuration should be specified in the global section");
        this.init(cfg);
    }

    @Test
    public void refuseConfigurationFileOnSpecificIndex() throws Throwable {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().addProperty("hibernate.search.dvds.worker.backend", "jgroupsMaster").addProperty("hibernate.search.dvds.worker.backend.jgroups.configurationFile", "some non existing file");
        this.error.expect(SearchException.class);
        this.error.expectMessage("JGroups channel configuration should be specified in the global section");
        this.init(cfg);
    }

    @Test
    public void acceptConfigurationFile() throws Throwable {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().addProperty("hibernate.search.dvds.worker.backend", "jgroupsMaster").addProperty("hibernate.search.services.jgroups.configurationFile", "some non existing file");
        this.error.expect(SearchException.class);
        this.error.expectMessage("Error while trying to create a channel using config file: some non existing file");
        this.init(cfg);
    }

    private void init(SearchConfigurationForTest cfg) throws Throwable {
        cfg.addClass(Dvd.class);
        this.integratorResource.create((SearchConfiguration)cfg);
    }

    @Indexed(index="dvds")
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }
}

