/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jms.impl;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.jms.impl.JmsBackendQueueTask;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class JmsBackendQueueProcessor
implements BackendQueueProcessor {
    private String jmsQueueName;
    protected static final String JNDI_PREFIX = "worker.jndi.";
    private Queue jmsQueue;
    private String indexName;
    private SearchFactoryImplementor searchFactory;
    private QueueConnection connection;
    public static final String JMS_CONNECTION_FACTORY = "worker.jms.connection_factory";
    public static final String JMS_QUEUE = "worker.jms.queue";
    public static final String JMS_CONNECTION_LOGIN = "worker.jms.login";
    public static final String JMS_CONNECTION_PASSWORD = "worker.jms.password";
    private IndexManager indexManager;
    private static final Log log = LoggerFactory.make();

    public void initialize(Properties props, WorkerBuildContext context, DirectoryBasedIndexManager indexManager) {
        this.indexManager = indexManager;
        this.jmsQueueName = props.getProperty(JMS_QUEUE);
        this.indexName = indexManager.getIndexName();
        this.searchFactory = context.getUninitializedSearchFactory();
        QueueConnectionFactory factory = this.initializeJMSQueueConnectionFactory(props);
        this.jmsQueue = this.initializeJMSQueue(factory, props);
        this.connection = this.initializeJMSConnection(factory, props);
    }

    public Queue getJmsQueue() {
        return this.jmsQueue;
    }

    public String getJmsQueueName() {
        return this.jmsQueueName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public SearchFactoryImplementor getSearchFactory() {
        return this.searchFactory;
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (workList == null) {
            throw new IllegalArgumentException("workList should not be null");
        }
        JmsBackendQueueTask operation = new JmsBackendQueueTask(this.indexName, workList, this.indexManager, this);
        operation.run();
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        this.applyWork(Collections.singletonList(singleOperation), monitor);
    }

    public Lock getExclusiveWriteLock() {
        log.warnSuspiciousBackendDirectoryCombination(this.indexName);
        return new ReentrantLock();
    }

    public void indexMappingChanged() {
    }

    public QueueConnection getJMSConnection() {
        return this.connection;
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException e) {
            log.unableToCloseJmsConnection(this.jmsQueueName, (Exception)((Object)e));
        }
    }

    protected abstract QueueConnectionFactory initializeJMSQueueConnectionFactory(Properties var1);

    protected abstract Queue initializeJMSQueue(QueueConnectionFactory var1, Properties var2);

    protected abstract QueueConnection initializeJMSConnection(QueueConnectionFactory var1, Properties var2);
}

