/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.gson.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.elasticsearch.gson.impl.ArrayElementJsonAccessor;
import org.hibernate.search.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.elasticsearch.gson.impl.JsonCompositeAccessor;
import org.hibernate.search.elasticsearch.gson.impl.JsonElementType;
import org.hibernate.search.elasticsearch.gson.impl.TypingJsonAccessor;
import org.hibernate.search.elasticsearch.gson.impl.UnexpectedJsonElementTypeException;
import org.hibernate.search.elasticsearch.gson.impl.UnknownTypeJsonAccessor;

public class JsonArrayAccessorImpl
extends TypingJsonAccessor<JsonArray>
implements JsonArrayAccessor,
JsonCompositeAccessor<JsonArray> {
    public JsonArrayAccessorImpl(JsonAccessor<JsonElement> parentAccessor) {
        super(parentAccessor);
    }

    @Override
    protected JsonElementType<JsonArray> getExpectedElementType() {
        return JsonElementType.ARRAY;
    }

    @Override
    public JsonArray getOrCreate(JsonObject root) throws UnexpectedJsonElementTypeException {
        return this.getOrCreate(root, JsonArray::new);
    }

    @Override
    public UnknownTypeJsonAccessor element(int index) {
        return new ArrayElementJsonAccessor(this, index);
    }
}

