/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.gson.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.elasticsearch.gson.impl.CrawlingJsonAccessor;
import org.hibernate.search.elasticsearch.gson.impl.JsonCompositeAccessor;

class ObjectPropertyJsonAccessor
extends CrawlingJsonAccessor<JsonObject> {
    private final String propertyName;

    public ObjectPropertyJsonAccessor(JsonCompositeAccessor<JsonObject> parentAccessor, String propertyName) {
        super(parentAccessor);
        this.propertyName = propertyName;
    }

    @Override
    protected JsonElement doGet(JsonObject parent) {
        return parent.get(this.propertyName);
    }

    @Override
    protected void doSet(JsonObject parent, JsonElement newValue) {
        parent.add(this.propertyName, newValue);
    }

    @Override
    protected void appendRuntimeRelativePath(StringBuilder path) {
        path.append(".").append(this.propertyName);
    }

    @Override
    protected void appendStaticRelativePath(StringBuilder path, boolean isFirst) {
        if (!isFirst) {
            path.append(".");
        }
        path.append(this.propertyName);
    }
}

