/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl.translation;

import com.google.gson.JsonElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalysisDefinition;
import org.hibernate.search.elasticsearch.settings.impl.translation.AnalysisDefinitionFactory;
import org.hibernate.search.elasticsearch.settings.impl.translation.ParametersTransformer;
import org.hibernate.search.util.impl.ClassLoaderHelper;

class SimpleAnalysisDefinitionFactory<D extends AnalysisDefinition>
implements AnalysisDefinitionFactory<D> {
    private final Class<D> targetClass;
    private final String type;
    private final List<ParametersTransformer> parameterTransformers;

    public SimpleAnalysisDefinitionFactory(Class<D> targetClazz, String type, List<ParametersTransformer> parameterTransformers) {
        this.targetClass = targetClazz;
        this.type = type;
        this.parameterTransformers = parameterTransformers;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public D create(Map<String, String> parameters) {
        AnalysisDefinition result = (AnalysisDefinition)ClassLoaderHelper.untypedInstanceFromClass(this.targetClass, (String)"analysis definition");
        result.setType(this.type);
        LinkedHashMap<String, JsonElement> elasticsearchParameterMap = new LinkedHashMap<String, JsonElement>();
        for (ParametersTransformer transformer : this.parameterTransformers) {
            elasticsearchParameterMap.putAll(transformer.transform(parameters));
        }
        if (!elasticsearchParameterMap.isEmpty()) {
            result.setParameters(elasticsearchParameterMap);
        }
        return (D)result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "targetClass = " + this.targetClass + ", type = " + this.type + ", parameterTransformers = " + this.parameterTransformers + "]";
    }
}

