/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.document.DateTools;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchDateHelper;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class ElasticsearchDateHelperTest {
    @Test
    public void formatAndParse() {
        Calendar dateOfBirth = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        dateOfBirth.set(1958, 3, 7, 0, 0, 0);
        dateOfBirth.set(14, 0);
        this.assertSameTimeAfterFormatAndParse(dateOfBirth);
        Calendar subscriptionEndDate = GregorianCalendar.getInstance(TimeZone.getTimeZone("Europe/Paris"), Locale.FRENCH);
        subscriptionEndDate.set(2016, 5, 7, 4, 4, 4);
        this.assertSameTimeAfterFormatAndParse(subscriptionEndDate);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-3237")
    public void parseHibernateSearch510AndBelowFormat() {
        Calendar dateOfBirth = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        dateOfBirth.set(1958, 3, 7, 0, 0, 0);
        dateOfBirth.set(14, 0);
        dateOfBirth = ElasticsearchDateHelper.round((Calendar)dateOfBirth, (DateTools.Resolution)DateTools.Resolution.DAY);
        Assert.assertEquals((Object)dateOfBirth.getTime(), (Object)ElasticsearchDateHelper.stringToCalendar((String)"1958-04-07T00:00:00Z").getTime());
        Assert.assertEquals((Object)dateOfBirth.getTime(), (Object)ElasticsearchDateHelper.stringToDate((String)"1958-04-07T00:00:00Z"));
        Calendar subscriptionEndDate = GregorianCalendar.getInstance(TimeZone.getTimeZone("Europe/Paris"), Locale.FRENCH);
        subscriptionEndDate.set(2016, 5, 7, 4, 4, 4);
        subscriptionEndDate = ElasticsearchDateHelper.round((Calendar)subscriptionEndDate, (DateTools.Resolution)DateTools.Resolution.DAY);
        Assert.assertEquals((Object)subscriptionEndDate.getTime(), (Object)ElasticsearchDateHelper.stringToCalendar((String)"2016-06-07T02:00:00+02:00").getTime());
        Assert.assertEquals((Object)subscriptionEndDate.getTime(), (Object)ElasticsearchDateHelper.stringToDate((String)"2016-06-07T02:00:00+02:00"));
    }

    private void assertSameTimeAfterFormatAndParse(Calendar calendar) {
        Assert.assertEquals((Object)calendar.getTime(), (Object)ElasticsearchDateHelper.stringToCalendar((String)ElasticsearchDateHelper.calendarToString((Calendar)calendar)).getTime());
        Date date = calendar.getTime();
        Assert.assertEquals((Object)date, (Object)ElasticsearchDateHelper.stringToDate((String)ElasticsearchDateHelper.dateToString((Date)date)));
    }
}

