/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import com.google.gson.JsonObject;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.dialect.impl.DefaultElasticsearchDialectFactory;
import org.hibernate.search.elasticsearch.dialect.impl.ElasticsearchDialect;
import org.hibernate.search.elasticsearch.dialect.impl.es2.Elasticsearch2Dialect;
import org.hibernate.search.elasticsearch.dialect.impl.es50.Elasticsearch50Dialect;
import org.hibernate.search.elasticsearch.dialect.impl.es52.Elasticsearch52Dialect;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class DefaultElasticsearchDialectFactoryTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public ExpectedLog4jLog logged = ExpectedLog4jLog.create();
    private DefaultElasticsearchDialectFactory dialectFactory = new DefaultElasticsearchDialectFactory();
    @Mock
    private ElasticsearchClient clientMock;

    @Test
    public void es0() throws Exception {
        this.doMock("0.90.12");
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400081");
        this.thrown.expectMessage("'0.90.12'");
        this.dialectFactory.createDialect(this.clientMock, new Properties());
    }

    @Test
    public void es10() throws Exception {
        this.doMock("1.0.0");
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400081");
        this.thrown.expectMessage("'1.0.0'");
        this.dialectFactory.createDialect(this.clientMock, new Properties());
    }

    @Test
    public void es20() throws Exception {
        this.testSuccess("2.0.0", Elasticsearch2Dialect.class);
    }

    @Test
    public void es24() throws Exception {
        this.testSuccess("2.4.4", Elasticsearch2Dialect.class);
    }

    @Test
    public void es50() throws Exception {
        this.testSuccess("5.0.0", Elasticsearch50Dialect.class);
    }

    @Test
    public void es52() throws Exception {
        this.testSuccess("5.2.0", Elasticsearch52Dialect.class);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2748")
    public void es60() throws Exception {
        this.doMock("6.0.0");
        this.logged.expectMessage("HSEARCH400085", new String[]{"'6.0.0'"});
        ElasticsearchDialect dialect = this.dialectFactory.createDialect(this.clientMock, new Properties());
        Assertions.assertThat((Object)dialect).isInstanceOf(Elasticsearch52Dialect.class);
    }

    private void testSuccess(String versionString, Class<?> expectedDialectClass) throws Exception {
        this.doMock(versionString);
        ElasticsearchDialect dialect = this.dialectFactory.createDialect(this.clientMock, new Properties());
        Assertions.assertThat((Object)dialect).isInstanceOf(expectedDialectClass);
    }

    private void doMock(String versionString) throws Exception {
        JsonObject responseBody = JsonBuilder.object().add("version", JsonBuilder.object().addProperty("number", versionString)).build();
        EasyMock.expect((Object)this.clientMock.submit((ElasticsearchRequest)EasyMock.anyObject())).andReturn(CompletableFuture.completedFuture(new ElasticsearchResponse(200, "", responseBody)));
        EasyMock.replay((Object[])new Object[]{this.clientMock});
    }
}

