/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.hibernate.search.elasticsearch.processor.impl.DefaultElasticsearchWorkBulker;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.elasticsearch.work.impl.BulkResult;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.test.util.FutureAssert;
import org.junit.Before;
import org.junit.Test;

public class DefaultElasticsearchWorkBulkerTest {
    private static final int DEFAULT_MIN_BULK_SIZE = 1;
    private static final int DEFAULT_MAX_BULK_SIZE = 10;
    private final List<Object> mocks = new ArrayList<Object>();
    private ElasticsearchWorkSequenceBuilder sequenceBuilderMock;
    private ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep bulkResultExtractionStepMock;
    private Function<List<BulkableElasticsearchWork<?>>, ElasticsearchWork<BulkResult>> bulkWorkFactoryMock;

    @Before
    public void initMocks() {
        this.sequenceBuilderMock = (ElasticsearchWorkSequenceBuilder)EasyMock.createStrictMock(ElasticsearchWorkSequenceBuilder.class);
        this.bulkResultExtractionStepMock = (ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep)EasyMock.createStrictMock(ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep.class);
        this.bulkWorkFactoryMock = (Function)EasyMock.createStrictMock(Function.class);
        this.mocks.addAll(Arrays.asList(this.sequenceBuilderMock, this.bulkWorkFactoryMock));
    }

    @Test
    public void simple() {
        BulkableElasticsearchWork work1 = this.bulkableWork(1);
        BulkableElasticsearchWork work2 = this.bulkableWork(2);
        ElasticsearchWork bulkWork = this.work(3);
        Capture bulkWorkFutureCapture = EasyMock.newCapture();
        CompletableFuture bulkWorkResultFuture = new CompletableFuture();
        this.replay();
        DefaultElasticsearchWorkBulker bulker = new DefaultElasticsearchWorkBulker(this.sequenceBuilderMock, this.bulkWorkFactoryMock, 1, 10);
        this.verify();
        this.reset();
        this.replay();
        bulker.add(work1);
        this.verify();
        this.reset();
        this.replay();
        bulker.add(work2);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.sequenceBuilderMock.addBulkExecution((CompletableFuture)EasyMock.capture((Capture)bulkWorkFutureCapture))).andReturn(bulkWorkResultFuture);
        EasyMock.expect((Object)this.sequenceBuilderMock.startBulkResultExtraction(bulkWorkResultFuture)).andReturn((Object)this.bulkResultExtractionStepMock);
        this.bulkResultExtractionStepMock.add(work1, 0);
        this.bulkResultExtractionStepMock.add(work2, 1);
        this.replay();
        bulker.flushBulked();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWorkFutureCapture.getValue())).isPending();
        this.reset();
        EasyMock.expect(this.bulkWorkFactoryMock.apply(Arrays.asList(work1, work2))).andReturn(bulkWork);
        this.replay();
        bulker.flushBulk();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWorkFutureCapture.getValue())).isSuccessful(bulkWork);
    }

    @Test
    public void noBulkIfBelowThreshold() {
        BulkableElasticsearchWork work1 = this.bulkableWork(1);
        this.replay();
        DefaultElasticsearchWorkBulker bulker = new DefaultElasticsearchWorkBulker(this.sequenceBuilderMock, this.bulkWorkFactoryMock, 2, 10);
        this.verify();
        this.reset();
        this.replay();
        bulker.add(work1);
        this.verify();
        this.reset();
        this.sequenceBuilderMock.addNonBulkExecution(work1);
        this.replay();
        bulker.flushBulked();
        this.verify();
        this.reset();
        this.replay();
        bulker.flushBulk();
        this.verify();
    }

    @Test
    public void alwaysBulkIfAboveThreshold() {
        BulkableElasticsearchWork work1 = this.bulkableWork(1);
        ElasticsearchWork bulkWork = this.work(2);
        Capture bulkWorkFutureCapture = EasyMock.newCapture();
        CompletableFuture bulkWorkResultFuture = new CompletableFuture();
        this.replay();
        DefaultElasticsearchWorkBulker bulker = new DefaultElasticsearchWorkBulker(this.sequenceBuilderMock, this.bulkWorkFactoryMock, 1, 10);
        this.verify();
        this.reset();
        this.replay();
        bulker.add(work1);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.sequenceBuilderMock.addBulkExecution((CompletableFuture)EasyMock.capture((Capture)bulkWorkFutureCapture))).andReturn(bulkWorkResultFuture);
        EasyMock.expect((Object)this.sequenceBuilderMock.startBulkResultExtraction(bulkWorkResultFuture)).andReturn((Object)this.bulkResultExtractionStepMock);
        this.bulkResultExtractionStepMock.add(work1, 0);
        this.replay();
        bulker.flushBulked();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWorkFutureCapture.getValue())).isPending();
        this.reset();
        EasyMock.expect(this.bulkWorkFactoryMock.apply(Arrays.asList(work1))).andReturn(bulkWork);
        this.replay();
        bulker.flushBulk();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWorkFutureCapture.getValue())).isSuccessful(bulkWork);
    }

    @Test
    public void sameBulkOnFlushBulked() {
        BulkableElasticsearchWork work1 = this.bulkableWork(1);
        BulkableElasticsearchWork work2 = this.bulkableWork(2);
        BulkableElasticsearchWork work3 = this.bulkableWork(3);
        BulkableElasticsearchWork work4 = this.bulkableWork(4);
        ElasticsearchWork bulkWork = this.work(5);
        Capture bulkWorkFutureCapture = EasyMock.newCapture();
        CompletableFuture bulkWorkResultFuture = new CompletableFuture();
        this.replay();
        DefaultElasticsearchWorkBulker bulker = new DefaultElasticsearchWorkBulker(this.sequenceBuilderMock, this.bulkWorkFactoryMock, 1, 10);
        this.verify();
        this.reset();
        this.replay();
        bulker.add(work1);
        bulker.add(work2);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.sequenceBuilderMock.addBulkExecution((CompletableFuture)EasyMock.capture((Capture)bulkWorkFutureCapture))).andReturn(bulkWorkResultFuture);
        EasyMock.expect((Object)this.sequenceBuilderMock.startBulkResultExtraction(bulkWorkResultFuture)).andReturn((Object)this.bulkResultExtractionStepMock);
        this.bulkResultExtractionStepMock.add(work1, 0);
        this.bulkResultExtractionStepMock.add(work2, 1);
        this.replay();
        bulker.flushBulked();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWorkFutureCapture.getValue())).isPending();
        this.reset();
        this.replay();
        bulker.add(work3);
        bulker.add(work4);
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWorkFutureCapture.getValue())).isPending();
        this.reset();
        EasyMock.expect((Object)this.sequenceBuilderMock.startBulkResultExtraction(bulkWorkResultFuture)).andReturn((Object)this.bulkResultExtractionStepMock);
        this.bulkResultExtractionStepMock.add(work3, 2);
        this.bulkResultExtractionStepMock.add(work4, 3);
        this.replay();
        bulker.flushBulked();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWorkFutureCapture.getValue())).isPending();
        this.reset();
        EasyMock.expect(this.bulkWorkFactoryMock.apply(Arrays.asList(work1, work2, work3, work4))).andReturn(bulkWork);
        this.replay();
        bulker.flushBulk();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWorkFutureCapture.getValue())).isSuccessful(bulkWork);
    }

    @Test
    public void newBulkOnFlushBulk() {
        BulkableElasticsearchWork work1 = this.bulkableWork(1);
        BulkableElasticsearchWork work2 = this.bulkableWork(2);
        BulkableElasticsearchWork work3 = this.bulkableWork(3);
        BulkableElasticsearchWork work4 = this.bulkableWork(4);
        ElasticsearchWork bulkWork1 = this.work(5);
        ElasticsearchWork bulkWork2 = this.work(6);
        CompletableFuture bulkWork1ResultFuture = new CompletableFuture();
        CompletableFuture bulkWork2ResultFuture = new CompletableFuture();
        Capture bulkWork1FutureCapture = EasyMock.newCapture();
        Capture bulkWork2FutureCapture = EasyMock.newCapture();
        this.replay();
        DefaultElasticsearchWorkBulker bulker = new DefaultElasticsearchWorkBulker(this.sequenceBuilderMock, this.bulkWorkFactoryMock, 1, 10);
        this.verify();
        this.reset();
        this.replay();
        bulker.add(work1);
        bulker.add(work2);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.sequenceBuilderMock.addBulkExecution((CompletableFuture)EasyMock.capture((Capture)bulkWork1FutureCapture))).andReturn(bulkWork1ResultFuture);
        EasyMock.expect((Object)this.sequenceBuilderMock.startBulkResultExtraction(bulkWork1ResultFuture)).andReturn((Object)this.bulkResultExtractionStepMock);
        this.bulkResultExtractionStepMock.add(work1, 0);
        this.bulkResultExtractionStepMock.add(work2, 1);
        this.replay();
        bulker.flushBulked();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWork1FutureCapture.getValue())).isPending();
        this.reset();
        EasyMock.expect(this.bulkWorkFactoryMock.apply(Arrays.asList(work1, work2))).andReturn(bulkWork1);
        this.replay();
        bulker.flushBulk();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWork1FutureCapture.getValue())).isSuccessful(bulkWork1);
        this.reset();
        this.replay();
        bulker.add(work3);
        bulker.add(work4);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.sequenceBuilderMock.addBulkExecution((CompletableFuture)EasyMock.capture((Capture)bulkWork2FutureCapture))).andReturn(bulkWork2ResultFuture);
        EasyMock.expect((Object)this.sequenceBuilderMock.startBulkResultExtraction(bulkWork2ResultFuture)).andReturn((Object)this.bulkResultExtractionStepMock);
        this.bulkResultExtractionStepMock.add(work3, 0);
        this.bulkResultExtractionStepMock.add(work4, 1);
        this.replay();
        bulker.flushBulked();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWork2FutureCapture.getValue())).isPending();
        this.reset();
        EasyMock.expect(this.bulkWorkFactoryMock.apply(Arrays.asList(work3, work4))).andReturn(bulkWork2);
        this.replay();
        bulker.flushBulk();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWork2FutureCapture.getValue())).isSuccessful(bulkWork2);
    }

    @Test
    public void newBulkOnTooManyBulkedWorks() {
        ArrayList firstBulkWorks = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            firstBulkWorks.add(this.bulkableWork(i));
        }
        BulkableElasticsearchWork additionalWork1 = this.bulkableWork(10);
        BulkableElasticsearchWork additionalWork2 = this.bulkableWork(11);
        ElasticsearchWork bulkWork1 = this.work(12);
        ElasticsearchWork bulkWork2 = this.work(13);
        CompletableFuture bulkWork1ResultFuture = new CompletableFuture();
        CompletableFuture bulkWork2ResultFuture = new CompletableFuture();
        Capture bulkWork1FutureCapture = EasyMock.newCapture();
        Capture bulkWork2FutureCapture = EasyMock.newCapture();
        this.replay();
        DefaultElasticsearchWorkBulker bulker = new DefaultElasticsearchWorkBulker(this.sequenceBuilderMock, this.bulkWorkFactoryMock, 1, 10);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.sequenceBuilderMock.addBulkExecution((CompletableFuture)EasyMock.capture((Capture)bulkWork1FutureCapture))).andReturn(bulkWork1ResultFuture);
        EasyMock.expect((Object)this.sequenceBuilderMock.startBulkResultExtraction(bulkWork1ResultFuture)).andReturn((Object)this.bulkResultExtractionStepMock);
        for (int i = 0; i < 10; ++i) {
            BulkableElasticsearchWork bulkableElasticsearchWork = (BulkableElasticsearchWork)firstBulkWorks.get(i);
            this.bulkResultExtractionStepMock.add(bulkableElasticsearchWork, i);
        }
        EasyMock.expect(this.bulkWorkFactoryMock.apply(firstBulkWorks)).andReturn(bulkWork1);
        this.replay();
        for (BulkableElasticsearchWork bulkableElasticsearchWork : firstBulkWorks) {
            bulker.add(bulkableElasticsearchWork);
        }
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWork1FutureCapture.getValue())).isSuccessful(bulkWork1);
        this.reset();
        this.replay();
        bulker.add(additionalWork1);
        bulker.add(additionalWork2);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.sequenceBuilderMock.addBulkExecution((CompletableFuture)EasyMock.capture((Capture)bulkWork2FutureCapture))).andReturn(bulkWork2ResultFuture);
        EasyMock.expect((Object)this.sequenceBuilderMock.startBulkResultExtraction(bulkWork2ResultFuture)).andReturn((Object)this.bulkResultExtractionStepMock);
        this.bulkResultExtractionStepMock.add(additionalWork1, 0);
        this.bulkResultExtractionStepMock.add(additionalWork2, 1);
        this.replay();
        bulker.flushBulked();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWork2FutureCapture.getValue())).isPending();
        this.reset();
        EasyMock.expect(this.bulkWorkFactoryMock.apply(Arrays.asList(additionalWork1, additionalWork2))).andReturn(bulkWork2);
        this.replay();
        bulker.flushBulk();
        this.verify();
        FutureAssert.assertThat((Future)((Future)bulkWork2FutureCapture.getValue())).isSuccessful(bulkWork2);
    }

    private void reset() {
        EasyMock.reset((Object[])this.mocks.toArray());
    }

    private void replay() {
        EasyMock.replay((Object[])this.mocks.toArray());
    }

    private void verify() {
        EasyMock.verify((Object[])this.mocks.toArray());
    }

    private <T> ElasticsearchWork<T> work(int index) {
        ElasticsearchWork mock = (ElasticsearchWork)EasyMock.createStrictMock((String)("work" + index), ElasticsearchWork.class);
        this.mocks.add(mock);
        return mock;
    }

    private <T> BulkableElasticsearchWork<T> bulkableWork(int index) {
        BulkableElasticsearchWork mock = (BulkableElasticsearchWork)EasyMock.createStrictMock((String)("bulkableWork" + index), BulkableElasticsearchWork.class);
        this.mocks.add(mock);
        return mock;
    }
}

