/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.nulls.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchAsNullStringNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchAsTokenStringNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchBooleanNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchDoubleNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchFloatNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchIntegerNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchLongNullMarkerCodec;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaTranslator;
import org.hibernate.search.engine.metadata.impl.PartialDocumentFieldMetadata;
import org.hibernate.search.engine.nulls.codec.impl.NullMarkerCodec;
import org.hibernate.search.engine.nulls.impl.MissingValueStrategy;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ElasticsearchMissingValueStrategy
implements MissingValueStrategy {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSchemaTranslator schemaTranslator;

    public ElasticsearchMissingValueStrategy(ElasticsearchSchemaTranslator schemaTranslator) {
        this.schemaTranslator = schemaTranslator;
    }

    public NullMarkerCodec createNullMarkerCodec(IndexedTypeIdentifier entityType, PartialDocumentFieldMetadata fieldMetadata, NullMarker nullMarker) {
        Object nullEncoded = nullMarker.nullEncoded();
        if (nullEncoded instanceof String) {
            if (this.schemaTranslator.isTextDataType(fieldMetadata)) {
                return new ElasticsearchAsTokenStringNullMarkerCodec(nullMarker);
            }
            return new ElasticsearchAsNullStringNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Integer) {
            return new ElasticsearchIntegerNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Long) {
            return new ElasticsearchLongNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Float) {
            return new ElasticsearchFloatNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Double) {
            return new ElasticsearchDoubleNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Boolean) {
            return new ElasticsearchBooleanNullMarkerCodec(nullMarker);
        }
        throw LOG.unsupportedNullTokenType(entityType, fieldMetadata.getPath().getRelativeName(), nullEncoded.getClass());
    }
}

