/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.lang.invoke.MethodHandles;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.spi.IgnoreAnalyzerBridge;
import org.hibernate.search.bridge.util.impl.EncodingStringBridge;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class ElasticsearchTemporalAccessorStringBridge<T extends TemporalAccessor>
extends EncodingStringBridge<T>
implements TwoWayStringBridge,
IgnoreAnalyzerBridge {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final DateTimeFormatter formatter;
    private final Class<T> type;
    private final DateTimeFormatter indexNullAsFormatter;

    ElasticsearchTemporalAccessorStringBridge(DateTimeFormatter formatter, Class<T> type) {
        this(formatter, type, formatter);
    }

    ElasticsearchTemporalAccessorStringBridge(DateTimeFormatter formatter, Class<T> type, DateTimeFormatter indexNullAsFormatter) {
        this.formatter = formatter;
        this.type = type;
        this.indexNullAsFormatter = indexNullAsFormatter;
    }

    public String objectToString(Object object) {
        if (object == null) {
            return null;
        }
        String formatted = this.format(this.formatter, (TemporalAccessor)object);
        return formatted;
    }

    public Object stringToObject(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        try {
            return this.parse(this.formatter, stringValue);
        }
        catch (Exception e) {
            throw LOG.parseException(stringValue, this.type, e);
        }
    }

    String format(DateTimeFormatter formatter, T object) {
        return formatter.format((TemporalAccessor)object);
    }

    abstract T parse(DateTimeFormatter var1, String var2) throws DateTimeException;

    public NumericFieldSettingsDescriptor.NumericEncodingType getEncodingType() {
        return NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN;
    }

    protected T parseIndexNullAs(String indexNullAs) throws IllegalArgumentException {
        try {
            return this.parse(this.indexNullAsFormatter, indexNullAs);
        }
        catch (DateTimeException e) {
            throw this.createInvalidIndexNullAsException(indexNullAs, e);
        }
    }

    protected abstract IllegalArgumentException createInvalidIndexNullAsException(String var1, DateTimeException var2);
}

