/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import com.google.gson.JsonElement;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.hibernate.search.exception.AssertionFailure;

public final class URLEncodedString {
    public final String encoded;
    public final String original;

    private URLEncodedString(String string) {
        this.original = string;
        try {
            this.encoded = URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionFailure("Unexpected error retrieving the UTF-8 charset", (Throwable)e);
        }
    }

    public String toString() {
        return this.original;
    }

    public int hashCode() {
        return this.original.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (URLEncodedString.class != obj.getClass()) {
            return false;
        }
        URLEncodedString other = (URLEncodedString)obj;
        return this.original.equals(other.original);
    }

    public static URLEncodedString fromString(String string) {
        Objects.requireNonNull(string);
        return new URLEncodedString(string);
    }

    public static URLEncodedString fromJSon(JsonElement jsonElement) {
        Objects.requireNonNull(jsonElement);
        return URLEncodedString.fromString(jsonElement.getAsString());
    }
}

