/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Date;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidationException;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.test.util.impl.ExceptionMatcherBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ElasticsearchSchemaValidationIT
extends SearchInitializationTestBase {
    private static final String VALIDATION_FAILED_MESSAGE_ID = "HSEARCH400033";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();

    protected void init(Class<?> ... annotatedClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", IndexSchemaManagementStrategy.VALIDATE.name());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])annotatedClasses));
    }

    @Test
    public void success_simple() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed','ignore_malformed': true},'NOTmyField': {'type': 'date','index': 'not_analyzed'}}}");
        this.elasticSearchClient.index(SimpleBooleanEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleBooleanEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean','index': 'not_analyzed'},'NOTmyField': {'type': 'boolean','index': 'not_analyzed'}}}");
        this.elasticSearchClient.index(FacetedDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(FacetedDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed','ignore_malformed': true,'fields': {'myField__HSearch_Facet': {'type': 'date','index': 'not_analyzed'}}},'NOTmyField': {'type': 'date','index': 'not_analyzed'}}}");
        this.init(SimpleDateEntity.class, SimpleBooleanEntity.class, FacetedDateEntity.class);
    }

    @Test
    public void mapping_missing() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("\n\tMissing type mapping").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void rootMapping_attribute_missing() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleDateEntity.class).put("{'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("\n\tInvalid value for attribute 'dynamic'. Expected 'STRICT', actual is 'null'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void rootMapping_attribute_dynamic_invalid() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleDateEntity.class).put("{'dynamic': false,'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("\n\tInvalid value for attribute 'dynamic'. Expected 'STRICT', actual is 'FALSE'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void properties_missing() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tMissing property mapping").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_missing() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'NOTmyField': {'type': 'date','index': 'not_analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tMissing property mapping").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_attribute_missing() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'object'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tInvalid value for attribute 'type'. Expected 'DATE', actual is 'OBJECT'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_attribute_invalid() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tInvalid value for attribute 'index'. Expected 'NOT_ANALYZED', actual is 'ANALYZED'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_format_invalidOutputFormat() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'epoch_millis||yyyy'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tThe output format (the first format in the 'format' attribute) is invalid. Expected 'strict_date_optional_time', actual is 'epoch_millis'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_format_missingInputFormat() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'strict_date_optional_time'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tInvalid formats for attribute 'format'").withMessage("missing elements are '[epoch_millis]'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_format_unexpectedInputFormat() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis||yyyy'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tInvalid formats for attribute 'format'").withMessage("unexpected elements are '[yyyy]'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_attribute_leniency() throws Exception {
        this.elasticSearchClient.index(SimpleLenientEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleLenientEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'long','index': 'analyzed','store': 'yes'}}}");
        this.init(SimpleLenientEntity.class);
    }

    @Test
    public void multipleErrors_singleIndexManagers() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleDateEntity.class).put("{'dynamic': false,'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("\nIndex 'org.hibernate.search.elasticsearch.test.elasticsearchschemavalidationit$simpledateentity', mapping 'org.hibernate.search.elasticsearch.test.ElasticsearchSchemaValidationIT$SimpleDateEntity':\n\tInvalid value for attribute 'dynamic'. Expected 'STRICT', actual is 'FALSE'\nIndex 'org.hibernate.search.elasticsearch.test.elasticsearchschemavalidationit$simpledateentity', mapping 'org.hibernate.search.elasticsearch.test.ElasticsearchSchemaValidationIT$SimpleDateEntity', property 'myField':\n\tInvalid value for attribute 'type'. Expected 'DATE', actual is 'STRING'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void multipleErrors_multipleIndexManagers() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleDateEntity.class).put("{'dynamic': false,'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string'}}}");
        this.elasticSearchClient.index(SimpleBooleanEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(SimpleBooleanEntity.class).put("{'dynamic': false,'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("\nIndex 'org.hibernate.search.elasticsearch.test.elasticsearchschemavalidationit$simplebooleanentity', mapping 'org.hibernate.search.elasticsearch.test.ElasticsearchSchemaValidationIT$SimpleBooleanEntity':\n\tInvalid value for attribute 'dynamic'. Expected 'STRICT', actual is 'FALSE'").withSuppressed(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("\nIndex 'org.hibernate.search.elasticsearch.test.elasticsearchschemavalidationit$simpledateentity', mapping 'org.hibernate.search.elasticsearch.test.ElasticsearchSchemaValidationIT$SimpleDateEntity':\n\tInvalid value for attribute 'dynamic'. Expected 'STRICT', actual is 'FALSE'\nIndex 'org.hibernate.search.elasticsearch.test.elasticsearchschemavalidationit$simpledateentity', mapping 'org.hibernate.search.elasticsearch.test.ElasticsearchSchemaValidationIT$SimpleDateEntity', property 'myField':\n\tInvalid value for attribute 'type'. Expected 'DATE', actual is 'STRING'").build()).build());
        this.init(SimpleBooleanEntity.class, SimpleDateEntity.class);
    }

    @Test
    public void property_fields_missing() throws Exception {
        this.elasticSearchClient.index(FacetedDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(FacetedDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField', field 'myField__HSearch_Facet'").withMessage("\n\tMissing field mapping").build());
        this.init(FacetedDateEntity.class);
    }

    @Test
    public void property_field_missing() throws Exception {
        this.elasticSearchClient.index(FacetedDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(FacetedDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed','fields': {'NOTmyField__HSearch_Facet': {'type': 'date','index': 'not_analyzed'}}}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField', field 'myField__HSearch_Facet'").withMessage("\n\tMissing field mapping").build());
        this.init(FacetedDateEntity.class);
    }

    @Test
    public void property_field_attribute_invalid() throws Exception {
        this.elasticSearchClient.index(FacetedDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(FacetedDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed','fields': {'myField__HSearch_Facet': {'type': 'date','index': 'analyzed'}}}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField', field 'myField__HSearch_Facet'").withMessage("\n\tInvalid value for attribute 'index'. Expected 'NOT_ANALYZED', actual is 'ANALYZED'").build());
        this.init(FacetedDateEntity.class);
    }

    @Indexed
    @Entity
    public static class FacetedDateEntity {
        @DocumentId
        @Id
        Long id;
        @Field(analyze=Analyze.NO)
        @Facet
        Date myField;
    }

    @Indexed
    @Entity
    public static class SimpleLenientEntity {
        @DocumentId
        @Id
        Long id;
        @Field(index=Index.NO, store=Store.NO)
        Long myField;
    }

    @Indexed
    @Entity
    public static class SimpleDateEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Date myField;
    }

    @Indexed
    @Entity
    public static class SimpleBooleanEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Boolean myField;
    }
}

