/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.search.annotations.DynamicBoost;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.junit.Rule;
import org.junit.Test;

public class ElasticsearchUnsupportedFeaturesIT
extends SearchInitializationTestBase {
    @Rule
    public ExpectedLog4jLog logged = ExpectedLog4jLog.create();

    @Test
    public void dynamicBoosting() throws Exception {
        this.logged.expectMessage("HSEARCH400032", new String[]{"@DynamicBoost", DynamicBoostingEntity.class.getSimpleName()});
        this.init(new Class[]{DynamicBoostingEntity.class});
    }

    public static class CustomBoostStrategy
    implements BoostStrategy {
        public float defineBoost(Object value) {
            DynamicBoostingEntity entity = (DynamicBoostingEntity)value;
            return entity.getBoost().floatValue();
        }
    }

    @Indexed
    @Entity
    @DynamicBoost(impl=CustomBoostStrategy.class)
    public static class DynamicBoostingEntity {
        @Id
        @GeneratedValue
        private Integer id;
        private Float boost;
        @Field
        private String data;

        public Integer getId() {
            return this.id;
        }

        public Float getBoost() {
            return this.boost;
        }

        public void setBoost(Float boost) {
            this.boost = boost;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}

