/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import org.hibernate.search.elasticsearch.util.impl.Window;
import org.junit.Assert;
import org.junit.Test;

public class WindowTest {
    @Test
    public void add_withinBounds() {
        Window window = new Window(4100, 100);
        window.add((Object)1);
        Assert.assertEquals((Object)1, (Object)window.get(4100));
        Assert.assertEquals((long)4100L, (long)window.start());
        Assert.assertEquals((long)1L, (long)window.size());
        Assert.assertFalse((boolean)window.isEmpty());
        Assert.assertEquals((long)100L, (long)window.capacity());
        window.add((Object)2);
        Assert.assertEquals((Object)1, (Object)window.get(4100));
        Assert.assertEquals((Object)2, (Object)window.get(4101));
        Assert.assertEquals((long)4100L, (long)window.start());
        Assert.assertEquals((long)2L, (long)window.size());
        Assert.assertFalse((boolean)window.isEmpty());
        Assert.assertEquals((long)100L, (long)window.capacity());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void add_outOfBounds_after() {
        Window window = new Window(4100, 10);
        window.add((Object)1);
        window.add((Object)2);
        window.get(3);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void add_outOfBounds_before() {
        Window window = new Window(4100, 10);
        window.add((Object)1);
        window.add((Object)2);
        window.get(0);
    }

    @Test
    public void add_overflow() {
        Window window = new Window(10000, 4);
        window.add((Object)1);
        window.add((Object)2);
        window.add((Object)3);
        window.add((Object)4);
        Assert.assertEquals((Object)1, (Object)window.get(10000));
        Assert.assertEquals((Object)2, (Object)window.get(10001));
        Assert.assertEquals((Object)3, (Object)window.get(10002));
        Assert.assertEquals((Object)4, (Object)window.get(10003));
        Assert.assertEquals((long)10000L, (long)window.start());
        Assert.assertEquals((long)4L, (long)window.size());
        Assert.assertFalse((boolean)window.isEmpty());
        Assert.assertEquals((long)4L, (long)window.capacity());
        window.add((Object)5);
        Assert.assertEquals((Object)2, (Object)window.get(10001));
        Assert.assertEquals((Object)3, (Object)window.get(10002));
        Assert.assertEquals((Object)4, (Object)window.get(10003));
        Assert.assertEquals((Object)5, (Object)window.get(10004));
        Assert.assertEquals((long)10001L, (long)window.start());
        Assert.assertEquals((long)4L, (long)window.size());
        Assert.assertFalse((boolean)window.isEmpty());
        Assert.assertEquals((long)4L, (long)window.capacity());
    }

    @Test
    public void clear() {
        Window window = new Window(12, 10);
        window.add((Object)1);
        window.add((Object)2);
        Assert.assertEquals((long)2L, (long)window.size());
        Assert.assertFalse((boolean)window.isEmpty());
        Assert.assertEquals((long)12L, (long)window.start());
        Assert.assertEquals((long)10L, (long)window.capacity());
        window.clear();
        Assert.assertEquals((long)0L, (long)window.size());
        Assert.assertTrue((boolean)window.isEmpty());
        Assert.assertEquals((long)12L, (long)window.start());
        Assert.assertEquals((long)10L, (long)window.capacity());
    }
}

