/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test.filter;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.elasticsearch.test.filter.Driver;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.test.SearchTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ElasticsearchFilterIT
extends SearchTestBase {
    @Test
    public void testElasticsearchFilter() {
        Session s = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        FullTextQuery ftQuery = fullTextSession.createFullTextQuery(ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all': {} } }"), new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        Assertions.assertThat((List)ftQuery.list()).onProperty("name").containsOnly(new Object[]{"Liz", "Emmanuel"});
        TermQuery termQuery = new TermQuery(new Term("name", "liz"));
        QueryWrapperFilter termFilter = new QueryWrapperFilter((Query)termQuery);
        ftQuery.setFilter((Filter)termFilter);
        Assertions.assertThat((List)ftQuery.list()).onProperty("name").containsOnly(new Object[]{"Liz"});
        tx.commit();
        s.close();
    }

    @Test
    public void testElasticsearchFilterWithParameters() {
        Session s = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        FullTextQuery ftQuery = fullTextSession.createFullTextQuery(ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all': {} } }"), new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("namedDriver").setParameter("name", (Object)"liz");
        Assertions.assertThat((List)ftQuery.list()).onProperty("name").containsOnly(new Object[]{"Liz"});
        tx.commit();
        s.close();
    }

    @Test
    public void testMixedFilters() {
        Session s = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        FullTextQuery ftQuery = fullTextSession.createFullTextQuery(ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all': {} } }"), new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("fieldConstraintFilter-1").setParameter("field", (Object)"teacher").setParameter("value", (Object)"andre");
        Assertions.assertThat((List)ftQuery.list()).onProperty("name").containsOnly(new Object[]{"Emmanuel"});
        tx.commit();
        s.close();
    }

    @Before
    public void setupTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        cal.set(2006, 10, 11);
        Driver driver = new Driver();
        driver.setDelivery(cal.getTime());
        driver.setId(1);
        driver.setName("Emmanuel");
        driver.setScore(5);
        driver.setTeacher("andre");
        s.persist((Object)driver);
        cal.set(2007, 10, 11);
        driver = new Driver();
        driver.setDelivery(cal.getTime());
        driver.setId(2);
        driver.setName("Gavin");
        driver.setScore(3);
        driver.setTeacher("aaron");
        s.persist((Object)driver);
        cal.set(2004, 10, 11);
        driver = new Driver();
        driver.setDelivery(cal.getTime());
        driver.setId(3);
        driver.setName("Liz");
        driver.setScore(5);
        driver.setTeacher("max");
        s.persist((Object)driver);
        tx.commit();
        s.close();
    }

    @After
    public void deleteTestData() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        for (Object entity : result) {
            session.delete(entity);
        }
        tx.commit();
        s.close();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Driver.class};
    }
}

