/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.settings.impl.ParametersTransformer;
import org.hibernate.search.util.impl.CollectionHelper;

class CjkBigramIgnoredScriptsParametersTransformer
implements ParametersTransformer {
    private static final Set<String> SCRIPTS = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{"han", "hiragana", "katakana", "hangul"}));

    CjkBigramIgnoredScriptsParametersTransformer() {
    }

    @Override
    public Map<String, JsonElement> transform(Map<String, String> luceneParameters) {
        JsonBuilder.Array ignoredScriptsBuilder = JsonBuilder.array();
        for (String script : SCRIPTS) {
            String value = luceneParameters.remove(script);
            if (value == null || Boolean.parseBoolean(value)) continue;
            ignoredScriptsBuilder.add((JsonElement)new JsonPrimitive(script));
        }
        JsonArray ignoredScripts = ignoredScriptsBuilder.build();
        if (ignoredScripts.size() > 0) {
            LinkedHashMap<String, JsonElement> result = new LinkedHashMap<String, JsonElement>();
            result.put("ignored_scripts", (JsonElement)ignoredScripts);
            return result;
        }
        return Collections.emptyMap();
    }
}

