/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.List;
import javax.persistence.EntityManager;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.elasticsearch.test.GolfCourse;
import org.hibernate.search.elasticsearch.test.GolfPlayer;
import org.hibernate.search.elasticsearch.test.Hole;
import org.hibernate.search.elasticsearch.testutil.JsonHelper;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.test.jpa.JPATestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ElasticsearchJpaIT
extends JPATestCase {
    @Before
    public void setupTestData() {
        EntityManager em = this.factory.createEntityManager();
        em.getTransaction().begin();
        GolfPlayer hergesheimer = new GolfPlayer.Builder().firstName("Klaus").lastName("Hergesheimer").build();
        em.persist((Object)hergesheimer);
        em.getTransaction().commit();
        em.close();
    }

    @After
    public void deleteTestData() {
        EntityManager em = this.factory.createEntityManager();
        FullTextEntityManager ftem = Search.getFullTextEntityManager((EntityManager)em);
        ftem.getTransaction().begin();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = ftem.createFullTextQuery(query, new Class[0]).getResultList();
        for (Object entity : result) {
            ftem.remove(entity);
        }
        ftem.getTransaction().commit();
        ftem.close();
    }

    @Test
    public void testQueryViaEntityManager() {
        EntityManager em = this.factory.createEntityManager();
        FullTextEntityManager ftem = Search.getFullTextEntityManager((EntityManager)em);
        ftem.getTransaction().begin();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'lastName' : 'Hergesheimer' } } }");
        Object[] result = (Object[])ftem.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"__HSearch_Source"}).getSingleResult();
        String source = (String)result[0];
        JsonHelper.assertJsonEqualsIgnoringUnknownFields("{'lastName': 'Hergesheimer','fullName': 'Klaus Hergesheimer',}", source);
        ftem.getTransaction().commit();
        ftem.close();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{GolfPlayer.class, GolfCourse.class, Hole.class};
    }
}

