/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchEnvironment;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.client.impl.BackendRequest;
import org.hibernate.search.elasticsearch.client.impl.BackendRequestProcessor;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexWorkVisitor;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaCreator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaDropper;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaTranslator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.elasticsearch.schema.impl.model.DynamicType;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexMetadata;
import org.hibernate.search.elasticsearch.spi.ElasticsearchIndexManagerType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.IndexNameNormalizer;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchIndexManager
implements IndexManager,
IndexNameNormalizer {
    static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private String indexName;
    private String actualIndexName;
    private boolean refreshAfterWrite;
    private IndexSchemaManagementStrategy schemaManagementStrategy;
    private ExecutionOptions schemaManagementExecutionOptions;
    private Similarity similarity;
    private ExtendedSearchIntegrator searchIntegrator;
    private final Set<Class<?>> containedEntityTypes = new HashSet();
    private boolean indexInitialized = false;
    private boolean indexCreatedByHibernateSearch = false;
    private final Set<Class<?>> initializedContainedEntityTypes = new HashSet();
    private ServiceManager serviceManager;
    private ElasticsearchIndexWorkVisitor visitor;
    private BackendRequestProcessor requestProcessor;
    private ElasticsearchSchemaCreator schemaCreator;
    private ElasticsearchSchemaDropper schemaDropper;
    private ElasticsearchSchemaMigrator schemaMigrator;
    private ElasticsearchSchemaValidator schemaValidator;
    private ElasticsearchSchemaTranslator schemaTranslator;

    public void initialize(String indexName, Properties properties, Similarity similarity, WorkerBuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.indexName = indexName;
        this.schemaManagementStrategy = ElasticsearchIndexManager.getIndexManagementStrategy(properties);
        final ElasticsearchIndexStatus requiredIndexStatus = ElasticsearchIndexManager.getRequiredIndexStatus(properties);
        final int indexManagementWaitTimeout = ElasticsearchIndexManager.getIndexManagementWaitTimeout(properties);
        final boolean multitenancyEnabled = context.isMultitenancyEnabled();
        final DynamicType dynamicMapping = ElasticsearchIndexManager.getDynamicMapping(properties);
        this.schemaManagementExecutionOptions = new ExecutionOptions(){

            @Override
            public ElasticsearchIndexStatus getRequiredIndexStatus() {
                return requiredIndexStatus;
            }

            @Override
            public int getIndexManagementTimeoutInMs() {
                return indexManagementWaitTimeout;
            }

            @Override
            public boolean isMultitenancyEnabled() {
                return multitenancyEnabled;
            }

            @Override
            public DynamicType getDynamicMapping() {
                return dynamicMapping;
            }
        };
        this.schemaCreator = (ElasticsearchSchemaCreator)this.serviceManager.requestService(ElasticsearchSchemaCreator.class);
        this.schemaDropper = (ElasticsearchSchemaDropper)this.serviceManager.requestService(ElasticsearchSchemaDropper.class);
        this.schemaMigrator = (ElasticsearchSchemaMigrator)this.serviceManager.requestService(ElasticsearchSchemaMigrator.class);
        this.schemaValidator = (ElasticsearchSchemaValidator)this.serviceManager.requestService(ElasticsearchSchemaValidator.class);
        this.schemaTranslator = (ElasticsearchSchemaTranslator)this.serviceManager.requestService(ElasticsearchSchemaTranslator.class);
        String overriddenIndexName = ElasticsearchIndexManager.getOverriddenIndexName(indexName, properties);
        this.actualIndexName = ElasticsearchIndexNameNormalizer.getElasticsearchIndexName(overriddenIndexName);
        this.refreshAfterWrite = ElasticsearchIndexManager.getRefreshAfterWrite(properties);
        this.similarity = similarity;
        this.visitor = new ElasticsearchIndexWorkVisitor(this.actualIndexName, this.refreshAfterWrite, context.getUninitializedSearchIntegrator());
        this.requestProcessor = (BackendRequestProcessor)context.getServiceManager().requestService(BackendRequestProcessor.class);
    }

    private static String getOverriddenIndexName(String indexName, Properties properties) {
        String name = properties.getProperty("indexName");
        return name != null ? name : indexName;
    }

    private static IndexSchemaManagementStrategy getIndexManagementStrategy(Properties properties) {
        String strategy = properties.getProperty("elasticsearch.index_schema_management_strategy");
        return strategy != null ? IndexSchemaManagementStrategy.valueOf(strategy) : ElasticsearchEnvironment.Defaults.INDEX_SCHEMA_MANAGEMENT_STRATEGY;
    }

    private static int getIndexManagementWaitTimeout(Properties properties) {
        int timeout = ConfigurationParseHelper.getIntValue((Properties)properties, (String)"elasticsearch.index_management_wait_timeout", (int)10000);
        if (timeout < 0) {
            throw LOG.negativeTimeoutValue(timeout);
        }
        return timeout;
    }

    private static DynamicType getDynamicMapping(Properties properties) {
        String status = ConfigurationParseHelper.getString((Properties)properties, (String)"elasticsearch.dynamic_mapping", (String)ElasticsearchEnvironment.Defaults.DYNAMIC_MAPPING.name());
        return DynamicType.valueOf(status.toUpperCase(Locale.ROOT));
    }

    private static ElasticsearchIndexStatus getRequiredIndexStatus(Properties properties) {
        String status = ConfigurationParseHelper.getString((Properties)properties, (String)"elasticsearch.required_index_status", null);
        if (status == null) {
            return ElasticsearchEnvironment.Defaults.REQUIRED_INDEX_STATUS;
        }
        return ElasticsearchIndexStatus.fromString(status);
    }

    private static boolean getRefreshAfterWrite(Properties properties) {
        return ConfigurationParseHelper.getBooleanValue((Properties)properties, (String)"elasticsearch.refresh_after_write", (boolean)false);
    }

    public void destroy() {
        if (this.schemaManagementStrategy == IndexSchemaManagementStrategy.RECREATE_DELETE) {
            this.schemaDropper.dropIfExisting(this.actualIndexName, this.schemaManagementExecutionOptions);
        }
        this.requestProcessor = null;
        this.serviceManager.releaseService(BackendRequestProcessor.class);
        this.schemaTranslator = null;
        this.serviceManager.releaseService(ElasticsearchSchemaTranslator.class);
        this.schemaValidator = null;
        this.serviceManager.releaseService(ElasticsearchSchemaValidator.class);
        this.schemaMigrator = null;
        this.serviceManager.releaseService(ElasticsearchSchemaMigrator.class);
        this.schemaDropper = null;
        this.serviceManager.releaseService(ElasticsearchSchemaDropper.class);
        this.schemaCreator = null;
        this.serviceManager.releaseService(ElasticsearchSchemaCreator.class);
        this.schemaManagementExecutionOptions = null;
        this.serviceManager = null;
    }

    public void setSearchFactory(ExtendedSearchIntegrator boundSearchIntegrator) {
        this.searchIntegrator = boundSearchIntegrator;
        this.initializeIndex();
    }

    private void initializeIndex() {
        if (!this.indexInitialized) {
            this.indexCreatedByHibernateSearch = this.initializeIndex(this.containedEntityTypes);
            this.indexInitialized = true;
            this.initializedContainedEntityTypes.addAll(this.containedEntityTypes);
        } else {
            HashSet notYetInitializedContainedEntityTypes = new HashSet(this.containedEntityTypes);
            notYetInitializedContainedEntityTypes.removeAll(this.initializedContainedEntityTypes);
            if (notYetInitializedContainedEntityTypes.isEmpty()) {
                return;
            }
            this.reinitializeIndex(notYetInitializedContainedEntityTypes);
            this.initializedContainedEntityTypes.addAll(notYetInitializedContainedEntityTypes);
        }
    }

    private boolean initializeIndex(Set<Class<?>> entityTypesToInitialize) {
        boolean createdIndex;
        if (this.schemaManagementStrategy == IndexSchemaManagementStrategy.NONE) {
            this.schemaCreator.checkIndexExists(this.actualIndexName, this.schemaManagementExecutionOptions);
            return false;
        }
        IndexMetadata indexMetadata = this.createIndexMetadata(entityTypesToInitialize);
        switch (this.schemaManagementStrategy) {
            case CREATE: {
                createdIndex = this.schemaCreator.createIndexIfAbsent(indexMetadata, this.schemaManagementExecutionOptions);
                if (!createdIndex) break;
                this.schemaCreator.createMappings(indexMetadata, this.schemaManagementExecutionOptions);
                break;
            }
            case RECREATE: 
            case RECREATE_DELETE: {
                this.schemaDropper.dropIfExisting(this.actualIndexName, this.schemaManagementExecutionOptions);
                this.schemaCreator.createIndex(indexMetadata, this.schemaManagementExecutionOptions);
                this.schemaCreator.createMappings(indexMetadata, this.schemaManagementExecutionOptions);
                createdIndex = true;
                break;
            }
            case MERGE: {
                createdIndex = this.schemaCreator.createIndexIfAbsent(indexMetadata, this.schemaManagementExecutionOptions);
                if (createdIndex) {
                    this.schemaCreator.createMappings(indexMetadata, this.schemaManagementExecutionOptions);
                    break;
                }
                this.schemaMigrator.merge(indexMetadata, this.schemaManagementExecutionOptions);
                break;
            }
            case VALIDATE: {
                this.schemaCreator.checkIndexExists(this.actualIndexName, this.schemaManagementExecutionOptions);
                this.schemaValidator.validate(indexMetadata, this.schemaManagementExecutionOptions);
                createdIndex = false;
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected schema management strategy: " + (Object)((Object)this.schemaManagementStrategy));
            }
        }
        return createdIndex;
    }

    private void reinitializeIndex(Set<Class<?>> entityTypesToInitialize) {
        if (this.schemaManagementStrategy == IndexSchemaManagementStrategy.NONE) {
            return;
        }
        IndexMetadata indexMetadata = this.createIndexMetadata(entityTypesToInitialize);
        switch (this.schemaManagementStrategy) {
            case CREATE: {
                if (!this.indexCreatedByHibernateSearch) break;
                this.schemaCreator.createMappings(indexMetadata, this.schemaManagementExecutionOptions);
                break;
            }
            case RECREATE: 
            case RECREATE_DELETE: {
                this.schemaCreator.createMappings(indexMetadata, this.schemaManagementExecutionOptions);
                break;
            }
            case MERGE: {
                this.schemaMigrator.merge(indexMetadata, this.schemaManagementExecutionOptions);
                break;
            }
            case VALIDATE: {
                this.schemaValidator.validate(indexMetadata, this.schemaManagementExecutionOptions);
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected schema management strategy: " + (Object)((Object)this.schemaManagementStrategy));
            }
        }
    }

    private IndexMetadata createIndexMetadata(Collection<Class<?>> classes) {
        ArrayList<EntityIndexBinding> descriptors = new ArrayList<EntityIndexBinding>();
        for (Class<?> entityType : classes) {
            EntityIndexBinding descriptor = this.searchIntegrator.getIndexBinding(entityType);
            descriptors.add(descriptor);
        }
        return this.schemaTranslator.translate(this.actualIndexName, descriptors, this.schemaManagementExecutionOptions);
    }

    public void addContainedEntity(Class<?> entity) {
        this.containedEntityTypes.add(entity);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ReaderProvider getReaderProvider() {
        throw LOG.indexManagerReaderProviderUnsupported();
    }

    public Set<Class<?>> getContainedTypes() {
        return this.containedEntityTypes;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public Analyzer getAnalyzer(String name) {
        return this.searchIntegrator.getAnalyzer(name);
    }

    public LuceneWorkSerializer getSerializer() {
        return null;
    }

    public void flushAndReleaseResources() {
    }

    public String getActualIndexName() {
        return this.actualIndexName;
    }

    public boolean needsRefreshAfterWrite() {
        return this.refreshAfterWrite;
    }

    public void performOperations(List<LuceneWork> workList, IndexingMonitor monitor) {
        ArrayList requests = new ArrayList(workList.size());
        for (LuceneWork luceneWork : workList) {
            requests.add((BackendRequest<?>)luceneWork.acceptIndexWorkVisitor((IndexWorkVisitor)this.visitor, (Object)monitor));
        }
        this.requestProcessor.executeSync(requests);
    }

    public void performStreamOperation(LuceneWork singleOperation, IndexingMonitor monitor, boolean forceAsync) {
        BackendRequest request = (BackendRequest)singleOperation.acceptIndexWorkVisitor((IndexWorkVisitor)this.visitor, (Object)monitor);
        if (singleOperation instanceof FlushLuceneWork) {
            this.requestProcessor.awaitAsyncProcessingCompletion();
            this.executeBackendRequest(request, true);
        } else {
            this.executeBackendRequest(request, false);
        }
    }

    private void executeBackendRequest(BackendRequest<?> backendRequest, boolean sync) {
        if (backendRequest != null) {
            if (sync) {
                this.requestProcessor.executeSync(Collections.singletonList(backendRequest));
            } else {
                this.requestProcessor.executeAsync(backendRequest);
            }
        }
    }

    public void awaitAsyncProcessingCompletion() {
        this.requestProcessor.awaitAsyncProcessingCompletion();
    }

    public void optimize() {
        this.performStreamOperation((LuceneWork)OptimizeLuceneWork.INSTANCE, null, false);
    }

    public String toString() {
        return "ElasticsearchIndexManager [actualIndexName=" + this.actualIndexName + "]";
    }

    public IndexManagerType getIndexManagerType() {
        return ElasticsearchIndexManagerType.INSTANCE;
    }
}

