/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Date;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizerFactory;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchCharFilterFactory;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchTokenFilterFactory;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.testutil.JsonHelper;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.test.util.impl.ExceptionMatcherBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ElasticsearchSchemaMigrationIT
extends SearchInitializationTestBase {
    private static final String MERGE_FAILED_MESSAGE_ID = "HSEARCH400035";
    private static final String MAPPING_CREATION_FAILED_MESSAGE_ID = "HSEARCH400020";
    private static final String ELASTICSEARCH_REQUEST_FAILED_MESSAGE_ID = "HSEARCH400007";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();

    protected void init(Class<?> ... annotatedClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", IndexSchemaManagementStrategy.MERGE.name());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])annotatedClasses));
    }

    @Test
    public void nothingToDo() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate().mapping(SimpleDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed','ignore_malformed': true},'NOTmyField': {'type': 'date','index': 'not_analyzed'}}}");
        this.elasticSearchClient.index(SimpleBooleanEntity.class).deleteAndCreate().mapping(SimpleBooleanEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean','index': 'not_analyzed'},'NOTmyField': {'type': 'boolean','index': 'not_analyzed'}}}");
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate();
        this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").put("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}");
        this.elasticSearchClient.mapping(AnalyzedEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string','analyzer': 'analyzerWithElasticsearchFactories'}}}");
        this.init(SimpleDateEntity.class, SimpleBooleanEntity.class, AnalyzedEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis','ignore_malformed': true},'NOTmyField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis'}}}", this.elasticSearchClient.mapping(SimpleDateEntity.class).get());
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean'},'NOTmyField': {'type': 'boolean'}}}", this.elasticSearchClient.mapping(SimpleBooleanEntity.class).get());
        JsonHelper.assertJsonEquals("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}", this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").get());
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string','analyzer': 'analyzerWithElasticsearchFactories'}}}", this.elasticSearchClient.mapping(AnalyzedEntity.class).get());
    }

    @Test
    public void mapping_missing() throws Exception {
        this.elasticSearchClient.index(SimpleBooleanEntity.class).deleteAndCreate();
        this.init(SimpleBooleanEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean'}}}", this.elasticSearchClient.mapping(SimpleBooleanEntity.class).get());
    }

    @Test
    public void rootMapping_attribute_missing() throws Exception {
        this.elasticSearchClient.index(SimpleBooleanEntity.class).deleteAndCreate().mapping(SimpleBooleanEntity.class).put("{'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean','index': 'not_analyzed'},'NOTmyField': {'type': 'boolean','index': 'not_analyzed'}}}");
        this.init(SimpleBooleanEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean'},'NOTmyField': {'type': 'boolean'}}}", this.elasticSearchClient.mapping(SimpleBooleanEntity.class).get());
    }

    @Test
    public void property_missing() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate().mapping(SimpleDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'NOTmyField': {'type': 'date','index': 'not_analyzed'}}}");
        this.init(SimpleDateEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis'},'NOTmyField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis'}}}", this.elasticSearchClient.mapping(SimpleDateEntity.class).get());
    }

    @Test
    public void property_attribute_invalid() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate().mapping(SimpleDateEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(SearchException.class).withMessage(MERGE_FAILED_MESSAGE_ID).causedBy(SearchException.class).withMessage(MAPPING_CREATION_FAILED_MESSAGE_ID).causedBy(SearchException.class).withMessage(ELASTICSEARCH_REQUEST_FAILED_MESSAGE_ID).withMessage("index").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_attribute_invalid_conflictingAnalyzer() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate();
        this.elasticSearchClient.mapping(AnalyzedEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string','analyzer': 'standard'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(SearchException.class).withMessage(MERGE_FAILED_MESSAGE_ID).causedBy(SearchException.class).withMessage(MAPPING_CREATION_FAILED_MESSAGE_ID).causedBy(SearchException.class).withMessage(ELASTICSEARCH_REQUEST_FAILED_MESSAGE_ID).withMessage("analyzer").build());
        this.init(AnalyzedEntity.class);
    }

    @Test
    public void analyzer_missing() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate();
        this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").put("{'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}");
        this.elasticSearchClient.mapping(AnalyzedEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true}}}");
        this.init(AnalyzedEntity.class);
        JsonHelper.assertJsonEquals("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}", this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").get());
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string','analyzer': 'analyzerWithElasticsearchFactories'}}}", this.elasticSearchClient.mapping(AnalyzedEntity.class).get());
    }

    @Test
    public void analyzer_componentDefinition_missing() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate();
        this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").put("{'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}");
        this.elasticSearchClient.mapping(AnalyzedEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true}}}");
        this.init(AnalyzedEntity.class);
        JsonHelper.assertJsonEquals("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}", this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").get());
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string','analyzer': 'analyzerWithElasticsearchFactories'}}}", this.elasticSearchClient.mapping(AnalyzedEntity.class).get());
    }

    @Test
    public void analyzer_componentReference_invalid() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate();
        this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").put("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['html_strip'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}");
        this.elasticSearchClient.mapping(AnalyzedEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string','analyzer': 'analyzerWithElasticsearchFactories'}}}");
        this.init(AnalyzedEntity.class);
        JsonHelper.assertJsonEquals("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}", this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").get());
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string','analyzer': 'analyzerWithElasticsearchFactories'}}}", this.elasticSearchClient.mapping(AnalyzedEntity.class).get());
    }

    @Test
    public void analyzer_componentDefinition_invalid() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate();
        this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").put("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'html_strip'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}");
        this.elasticSearchClient.mapping(AnalyzedEntity.class).put("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string','analyzer': 'analyzerWithElasticsearchFactories'}}}");
        this.init(AnalyzedEntity.class);
        JsonHelper.assertJsonEquals("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}", this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").get());
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string','analyzer': 'analyzerWithElasticsearchFactories'}}}", this.elasticSearchClient.mapping(AnalyzedEntity.class).get());
    }

    @Indexed
    @Entity
    @AnalyzerDef(name="analyzerWithElasticsearchFactories", charFilters={@CharFilterDef(name="custom-pattern-replace", factory=ElasticsearchCharFilterFactory.class, params={@Parameter(name="type", value="'pattern_replace'"), @Parameter(name="pattern", value="'[^0-9]'"), @Parameter(name="replacement", value="'0'"), @Parameter(name="tags", value="'CASE_INSENSITIVE|COMMENTS'")})}, tokenizer=@TokenizerDef(name="custom-edgeNGram", factory=EdgeNGramTokenizerFactory.class, params={@Parameter(name="minGramSize", value="1"), @Parameter(name="maxGramSize", value="10")}), filters={@TokenFilterDef(name="custom-keep-types", factory=ElasticsearchTokenFilterFactory.class, params={@Parameter(name="type", value="'keep_types'"), @Parameter(name="types", value="['<NUM>','<DOUBLE>']")})})
    public static class AnalyzedEntity {
        @DocumentId
        @Id
        Long id;
        @Field(analyzer=@Analyzer(definition="analyzerWithElasticsearchFactories"))
        String myField;
    }

    @Indexed
    @Entity
    public static class SimpleDateEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Date myField;
    }

    @Indexed
    @Entity
    public static class SimpleBooleanEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Boolean myField;
    }
}

