/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.elasticsearch.test.GolfPlayer;
import org.hibernate.search.elasticsearch.test.Hole;

@Entity
@Indexed
public class GolfCourse {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="GOLF_COURSE_SEQ")
    @SequenceGenerator(name="GOLF_COURSE_SEQ", sequenceName="golfcourse_sequence", allocationSize=20)
    @DocumentId
    private Long id;
    @Field
    private String name;
    @Field
    private double rating;
    @ContainedIn
    @ManyToMany
    private Set<GolfPlayer> playedBy = new HashSet<GolfPlayer>();
    @OneToMany(cascade={CascadeType.ALL})
    @IndexedEmbedded
    @OrderColumn
    private List<Hole> holes = new ArrayList<Hole>();

    GolfCourse() {
    }

    GolfCourse(String name, double rating, Hole ... holes) {
        this.name = name;
        this.rating = rating;
        if (holes != null) {
            for (Hole hole : holes) {
                this.holes.add(hole);
            }
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getRating() {
        return this.rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public Set<GolfPlayer> getPlayedBy() {
        return this.playedBy;
    }

    public void setPlayedBy(Set<GolfPlayer> playedBy) {
        this.playedBy = playedBy;
    }

    public List<Hole> getHoles() {
        return this.holes;
    }

    public void setHoles(List<Hole> holes) {
        this.holes = holes;
    }
}

