/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.testutil;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.cluster.Health;
import io.searchbox.core.Index;
import io.searchbox.indices.CloseIndex;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.DeleteIndex;
import io.searchbox.indices.OpenIndex;
import io.searchbox.indices.mapping.GetMapping;
import io.searchbox.indices.mapping.PutMapping;
import io.searchbox.indices.settings.GetSettings;
import io.searchbox.indices.settings.UpdateSettings;
import io.searchbox.indices.template.DeleteTemplate;
import io.searchbox.indices.template.PutTemplate;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchEnvironment;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.elasticsearch.impl.DefaultGsonService;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.rules.ExternalResource;

public class TestElasticsearchClient
extends ExternalResource {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private JestClient client;
    private final List<String> createdIndicesNames = Lists.newArrayList();
    private final List<String> createdTemplatesNames = Lists.newArrayList();
    private ElasticsearchIndexStatus requiredIndexStatus = ElasticsearchEnvironment.Defaults.REQUIRED_INDEX_STATUS;

    public TestElasticsearchClient requiredIndexStatus(ElasticsearchIndexStatus requiredIndexStatus) {
        this.requiredIndexStatus = requiredIndexStatus;
        return this;
    }

    public IndexClient index(Class<?> rootClass) {
        return new IndexClient(ElasticsearchIndexNameNormalizer.getElasticsearchIndexName((String)rootClass.getName()));
    }

    public IndexClient index(String indexName) {
        return new IndexClient(indexName);
    }

    public MappingClient mapping(Class<?> rootClass) {
        return this.index(rootClass).mapping(rootClass);
    }

    public TemplateClient template(String templateName) {
        return new TemplateClient(templateName);
    }

    private void deleteAndCreateIndex(String indexName) throws IOException {
        this.tryDeleteESIndex(indexName);
        JestResult result = this.client.execute((Action)new CreateIndex.Builder(indexName).build());
        this.registerIndexForCleanup(indexName);
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while creating index '" + indexName + "' for tests:" + result.getErrorMessage());
        }
        this.waitForIndexCreation(indexName);
    }

    private void createTemplate(String templateName, String templateString, JsonObject settings) throws IOException {
        JsonObject source = JsonBuilder.object().addProperty("template", templateString).add("settings", (JsonElement)settings).build();
        JestResult result = this.client.execute((Action)new PutTemplate.Builder(templateName, (Object)source).build());
        this.registerTemplateForCleanup(templateName);
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while creating template '" + templateName + "' for tests:" + result.getErrorMessage());
        }
    }

    private void ensureIndexDoesNotExist(String indexName) throws IOException {
        JestResult result = this.client.execute((Action)new DeleteIndex.Builder(indexName).build());
        if (!result.isSucceeded() && result.getResponseCode() != 404) {
            throw new AssertionFailure(String.format(Locale.ENGLISH, "Error while trying to delete index '%s' as part of test initialization: %s", indexName, result.getErrorMessage()));
        }
    }

    private void registerIndexForCleanup(String indexName) {
        this.createdIndicesNames.add(indexName);
    }

    private void registerTemplateForCleanup(String templateName) {
        this.createdTemplatesNames.add(templateName);
    }

    private void waitForIndexCreation(final String indexNameToWaitFor) throws IOException {
        Health.Builder healthBuilder = (Health.Builder)((Health.Builder)new Health.Builder().setParameter("wait_for_status", (Object)this.requiredIndexStatus.getElasticsearchString())).setParameter("timeout", (Object)"10000ms");
        Health health = new Health(healthBuilder){

            protected String buildURI() {
                try {
                    return super.buildURI() + URLEncoder.encode(indexNameToWaitFor, AbstractAction.CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionFailure("Unexpectedly unsupported charset", (Throwable)e);
                }
            }
        };
        JestResult result = this.client.execute((Action)health);
        if (!result.isSucceeded()) {
            String status = result.getJsonObject().get("status").getAsString();
            throw new AssertionFailure("Error while waiting for creation of index '" + indexNameToWaitFor + "' for tests (status was '" + status + "'):" + result.getErrorMessage());
        }
    }

    private void putMapping(String indexName, String mappingName, String mappingJson) throws IOException {
        JsonElement mappingJsonElement = this.toJsonElement(mappingJson);
        JestResult result = this.client.execute((Action)new PutMapping.Builder(indexName, mappingName, (Object)mappingJsonElement).build());
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while putting mapping '" + mappingName + "' on index '" + indexName + "' for tests:" + result.getErrorMessage());
        }
    }

    private String getMapping(String indexName, String mappingName) throws IOException {
        JestResult result = this.client.execute((Action)((GetMapping.Builder)((GetMapping.Builder)new GetMapping.Builder().addIndex(indexName)).addType(mappingName)).build());
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while getting mapping '" + mappingName + "' on index '" + indexName + "' for tests:" + result.getErrorMessage());
        }
        JsonElement index = result.getJsonObject().get(indexName);
        if (index == null) {
            return new JsonObject().toString();
        }
        JsonElement mappings = index.getAsJsonObject().get("mappings");
        if (mappings == null) {
            return new JsonObject().toString();
        }
        JsonElement mapping = mappings.getAsJsonObject().get(mappingName);
        if (mapping == null) {
            return new JsonObject().toString();
        }
        return mapping.toString();
    }

    private void putSettings(String indexName, String settingsPath, String settings) throws IOException {
        JsonElement settingsJsonElement = this.toJsonElement(settings);
        for (String property : Lists.reverse(Arrays.asList(settingsPath.split("\\.")))) {
            settingsJsonElement = JsonBuilder.object().add(property, settingsJsonElement).build();
        }
        JestResult result = this.client.execute((Action)new CloseIndex.Builder(indexName).build());
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while closing index '" + indexName + "' for tests:" + result.getErrorMessage());
        }
        result = this.client.execute((Action)((UpdateSettings.Builder)new UpdateSettings.Builder((Object)settingsJsonElement).addIndex(indexName)).build());
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while putting settings on index '" + indexName + "' for tests:" + result.getErrorMessage());
        }
        result = this.client.execute((Action)new OpenIndex.Builder(indexName).build());
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while re-opening index '" + indexName + "' for tests:" + result.getErrorMessage());
        }
    }

    private String getSettings(String indexName, String path) throws IOException {
        JestResult result = this.client.execute((Action)((GetSettings.Builder)new GetSettings.Builder().addIndex(indexName)).build());
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while getting settings on index '" + indexName + "' for tests:" + result.getErrorMessage());
        }
        JsonElement index = result.getJsonObject().get(indexName);
        if (index == null) {
            return new JsonObject().toString();
        }
        JsonElement settings = index.getAsJsonObject().get("settings");
        for (String property : path.split("\\.")) {
            if (settings == null) break;
            settings = settings.getAsJsonObject().get(property);
        }
        if (settings == null) {
            return new JsonObject().toString();
        }
        return settings.toString();
    }

    private void index(String indexName, String typeName, String id, String jsonDocument) throws IOException {
        JsonElement documentJsonElement = this.toJsonElement(jsonDocument);
        JestResult result = this.client.execute((Action)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)documentJsonElement).index(indexName)).type(typeName)).id(id)).refresh(true)).build());
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while indexing '" + jsonDocument + "' on index '" + indexName + "' for tests:" + result.getErrorMessage());
        }
    }

    protected void before() throws Throwable {
        JestClientFactory factory = new JestClientFactory();
        Gson gson = new DefaultGsonService().getGson();
        factory.setHttpClientConfig(((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder("http://localhost:9200").readTimeout(60000)).connTimeout(3000)).gson(gson)).build());
        this.client = factory.getObject();
    }

    protected void after() {
        for (String indexName : this.createdIndicesNames) {
            this.tryDeleteESIndex(indexName);
        }
        this.createdIndicesNames.clear();
        for (String templateName : this.createdTemplatesNames) {
            this.tryDeleteESTemplate(templateName);
        }
        this.createdTemplatesNames.clear();
        this.client.shutdownClient();
        this.client = null;
    }

    private void tryDeleteESIndex(String indexName) {
        try {
            JestResult result = this.client.execute((Action)new DeleteIndex.Builder(indexName).build());
            if (!result.isSucceeded() && result.getResponseCode() != 404) {
                LOG.warnf("Error while trying to delete index '%s' as part of test cleanup: %s", (Object)indexName, (Object)result.getErrorMessage());
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.warnf((Throwable)e, "Error while trying to delete index '%s' as part of test cleanup", (Object)indexName);
        }
    }

    private void tryDeleteESTemplate(String templateName) {
        try {
            JestResult result = this.client.execute((Action)new DeleteTemplate.Builder(templateName).build());
            if (!result.isSucceeded() && result.getResponseCode() != 404) {
                LOG.warnf("Error while trying to delete template '%s' as part of test cleanup: %s", (Object)templateName, (Object)result.getErrorMessage());
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.warnf((Throwable)e, "Error while trying to delete template '%s' as part of test cleanup", (Object)templateName);
        }
    }

    private JsonElement toJsonElement(String jsonAsString) {
        return new JsonParser().parse(jsonAsString);
    }

    public class TemplateClient {
        private final String templateName;

        public TemplateClient(String templateName) {
            this.templateName = templateName;
        }

        public TemplateClient create(String templateString, JsonObject settings) throws IOException {
            TestElasticsearchClient.this.createTemplate(this.templateName, templateString, settings);
            return this;
        }

        public TemplateClient registerForCleanup() {
            TestElasticsearchClient.this.registerTemplateForCleanup(this.templateName);
            return this;
        }
    }

    public class SettingsClient {
        private final IndexClient indexClient;
        private final String settingsPath;

        public SettingsClient(IndexClient indexClient, String settingsPath) {
            this.indexClient = indexClient;
            this.settingsPath = settingsPath;
        }

        public String get() throws IOException {
            return TestElasticsearchClient.this.getSettings(this.indexClient.indexName, this.settingsPath);
        }

        public void put(String settings) throws IOException {
            TestElasticsearchClient.this.putSettings(this.indexClient.indexName, this.settingsPath, settings);
        }
    }

    public class MappingClient {
        private final IndexClient indexClient;
        private final String mappingName;

        public MappingClient(IndexClient indexClient, String mappingName) {
            this.indexClient = indexClient;
            this.mappingName = mappingName;
        }

        public MappingClient put(String mappingJson) throws IOException {
            TestElasticsearchClient.this.putMapping(this.indexClient.indexName, this.mappingName, mappingJson);
            return this;
        }

        public String get() throws IOException {
            return TestElasticsearchClient.this.getMapping(this.indexClient.indexName, this.mappingName);
        }

        public MappingClient index(String id, String jsonDocument) throws IOException {
            TestElasticsearchClient.this.index(this.indexClient.indexName, this.mappingName, id, jsonDocument);
            return this;
        }
    }

    public class IndexClient {
        private final String indexName;

        public IndexClient(String indexName) {
            this.indexName = indexName;
        }

        public IndexClient deleteAndCreate() throws IOException {
            TestElasticsearchClient.this.deleteAndCreateIndex(this.indexName);
            return this;
        }

        public IndexClient ensureDoesNotExist() throws IOException {
            TestElasticsearchClient.this.ensureIndexDoesNotExist(this.indexName);
            return this;
        }

        public IndexClient registerForCleanup() {
            TestElasticsearchClient.this.registerIndexForCleanup(this.indexName);
            return this;
        }

        public MappingClient mapping(Class<?> mappingClass) {
            return this.mapping(mappingClass.getName());
        }

        public MappingClient mapping(String mappingName) {
            return new MappingClient(this, mappingName);
        }

        public SettingsClient settings() {
            return this.settings("");
        }

        public SettingsClient settings(String settingsPath) {
            return new SettingsClient(this, settingsPath);
        }
    }
}

