/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.elasticsearch.analyzer.impl.BuiltinElasticsearchAnalyzerImpl;
import org.hibernate.search.elasticsearch.analyzer.impl.CustomElasticsearchAnalyzerImpl;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzer;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.NamedElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.ScopedElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.SimpleElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.UndefinedElasticsearchAnalyzerImpl;

public class ElasticsearchAnalyzerStrategy
implements AnalyzerStrategy {
    public ElasticsearchAnalyzerReference createDefaultAnalyzerReference() {
        return new SimpleElasticsearchAnalyzerReference(new UndefinedElasticsearchAnalyzerImpl("default"));
    }

    public ElasticsearchAnalyzerReference createPassThroughAnalyzerReference() {
        return new SimpleElasticsearchAnalyzerReference(new UndefinedElasticsearchAnalyzerImpl("keyword"));
    }

    public NamedElasticsearchAnalyzerReference createNamedAnalyzerReference(String name) {
        return new NamedElasticsearchAnalyzerReference(name);
    }

    public ElasticsearchAnalyzerReference createAnalyzerReference(Class<?> analyzerClass) {
        return new SimpleElasticsearchAnalyzerReference(new BuiltinElasticsearchAnalyzerImpl(analyzerClass));
    }

    public void initializeAnalyzerReferences(Collection<AnalyzerReference> references, Map<String, AnalyzerDef> analyzerDefinitions) {
        HashMap<String, ElasticsearchAnalyzer> initializedAnalyzers = new HashMap<String, ElasticsearchAnalyzer>();
        for (AnalyzerReference reference : references) {
            ScopedElasticsearchAnalyzerReference scopedReference;
            if (reference.is(NamedElasticsearchAnalyzerReference.class)) {
                NamedElasticsearchAnalyzerReference namedReference = (NamedElasticsearchAnalyzerReference)reference.unwrap(NamedElasticsearchAnalyzerReference.class);
                this.initializeReference(initializedAnalyzers, namedReference, analyzerDefinitions);
                continue;
            }
            if (!reference.is(ScopedElasticsearchAnalyzerReference.class) || (scopedReference = (ScopedElasticsearchAnalyzerReference)reference.unwrap(ScopedElasticsearchAnalyzerReference.class)).isInitialized()) continue;
            scopedReference.initialize();
        }
    }

    private void initializeReference(Map<String, ElasticsearchAnalyzer> initializedAnalyzers, NamedElasticsearchAnalyzerReference analyzerReference, Map<String, AnalyzerDef> analyzerDefinitions) {
        String name = analyzerReference.getAnalyzerName();
        if (analyzerReference.isInitialized()) {
            initializedAnalyzers.put(name, analyzerReference.getAnalyzer());
            return;
        }
        ElasticsearchAnalyzer analyzer = initializedAnalyzers.get(name);
        if (analyzer == null) {
            AnalyzerDef analyzerDefinition = analyzerDefinitions.get(name);
            analyzer = analyzerDefinition == null ? new UndefinedElasticsearchAnalyzerImpl(name) : new CustomElasticsearchAnalyzerImpl(analyzerDefinition);
            initializedAnalyzers.put(name, analyzer);
        }
        analyzerReference.initialize(analyzer);
    }

    public ScopedAnalyzerReference.Builder buildScopedAnalyzerReference(AnalyzerReference initialGlobalAnalyzerReference) {
        return new ScopedElasticsearchAnalyzerReference.DeferredInitializationBuilder((ElasticsearchAnalyzerReference)initialGlobalAnalyzerReference.unwrap(ElasticsearchAnalyzerReference.class), Collections.emptyMap());
    }
}

