/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import io.searchbox.action.Action;
import io.searchbox.indices.settings.UpdateSettings;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.client.impl.JestClient;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.DefaultInstanceInitializer;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ElasticsearchFlushIT {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(new Class[]{Entity1.class, Entity2.class}).withProperty("hibernate.search.default.indexmanager", (Object)"elasticsearch").withProperty("hibernate.search.default.elasticsearch.refresh_after_write", (Object)"false").withProperty("hibernate.search.default.elasticsearch.index_schema_management_strategy", (Object)IndexSchemaManagementStrategy.RECREATE_DELETE.name()).withIdProvidedImplicit(true);

    @Test
    @TestForIssue(jiraKey="HSEARCH-2491")
    public void testFlushByEntity() throws Exception {
        this.increaseRefreshTime(Entity1.class, Entity2.class);
        Entity1 entity1 = new Entity1(1);
        Entity2 entity2 = new Entity2(1);
        this.indexAsStream((Serializable)((Object)"E1:1"), entity1);
        this.indexAsStream((Serializable)((Object)"E2:1"), entity2);
        this.assertIndexed(Entity1.class, 0);
        this.assertIndexed(Entity2.class, 0);
        this.flush(Entity1.class);
        this.assertIndexed(Entity1.class, 1);
        this.assertIndexed(Entity2.class, 0);
        this.flush(Entity2.class);
        this.assertIndexed(Entity1.class, 1);
        this.assertIndexed(Entity2.class, 1);
    }

    private void increaseRefreshTime(Class<?> ... indexes) {
        ServiceManager serviceManager = this.sfHolder.getSearchFactory().getServiceManager();
        try (ServiceReference client = serviceManager.requestReference(JestClient.class);){
            JestClient jestClient = (JestClient)client.get();
            String body = "{ \"index\" : { \"refresh_interval\" : \"3600s\"} }";
            UpdateSettings.Builder builder = new UpdateSettings.Builder((Object)body);
            for (Class<?> index : indexes) {
                builder.addIndex(index.getName().toLowerCase(Locale.getDefault()));
            }
            jestClient.executeRequest((Action)builder.build());
        }
    }

    private void flush(Class<?> clazz) {
        this.sfHolder.getBatchBackend().flush(Collections.singleton(clazz));
    }

    private void indexAsStream(Serializable id, Object entity) throws InterruptedException {
        LuceneWork work = this.createUpdateWork(id, entity);
        this.sfHolder.getBatchBackend().enqueueAsyncWork(work);
    }

    private LuceneWork createUpdateWork(Serializable id, Object entity) {
        Class<?> clazz = entity.getClass();
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        EntityIndexBinding entityIndexBinding = searchFactory.getIndexBinding(clazz);
        DocumentBuilderIndexedEntity docBuilder = entityIndexBinding.getDocumentBuilder();
        return docBuilder.createUpdateWork(null, clazz, entity, id, id.toString(), DefaultInstanceInitializer.DEFAULT_INITIALIZER, (ConversionContext)new ContextualExceptionBridgeHelper());
    }

    private void assertIndexed(Class<?> entity, int count) {
        HSQuery hsQuery = this.sfHolder.getSearchFactory().createHSQuery((Query)new MatchAllDocsQuery(), new Class[]{entity});
        Assert.assertEquals((long)count, (long)hsQuery.queryResultSize());
    }

    @Indexed
    private static class Entity2 {
        @Field
        private int id;

        Entity2(int id) {
            this.id = id;
        }
    }

    @Indexed
    private static class Entity1 {
        @Field
        private int id;

        Entity1(int id) {
            this.id = id;
        }
    }
}

